/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.dto.saldoanaliticocontribuinte.SaldoAnaliticoContribuinteConsultaDTO;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SaldoAnaliticoContribuinteRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SaldoAnaliticoContribuinteRepository.class);
    private static final String ENTIDADE = "entidade";
    private static final String DATA_REFERENCIA = "datareferencia";
    private static final String TIPO_AGRUPAMENTO = "tipoagrupamento";
    private static final String QUERY_SALDO_ANALITICO_CONTRIBUINTE = "br/com/elotech/tributos/repository/integracaocontabil/saldo-analitico-contribuinte.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public SaldoAnaliticoContribuinteRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<SaldoAnaliticoContribuinteConsultaDTO> getSaldoAnaliticoContribuinte(Long entidade, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(TIPO_AGRUPAMENTO, (Object)ConsultaDebitoTipoAgrupamento.SALDO_ANALITICO_CONTRIBUINTE_PRIMEIRA_CARGA.name());
        parameters.addValue(DATA_REFERENCIA, (Object)dataFinal);
        LOG.info("Efetuando a consulta do saldo anal\u00edtico de contribuintes com os par\u00e2metros: [{}]", (Object)parameters);
        String sql = FileUtils.readResourceAsString((String)QUERY_SALDO_ANALITICO_CONTRIBUINTE);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(SaldoAnaliticoContribuinteConsultaDTO.class));
    }
}

