/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.TotalizadoresBaixaAutomaticaDTO;
import br.com.elotech.tributos.repository.BaixaAutomaticaDetalheRepositoryCustom;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BaixaAutomaticaDetalheRepository
extends CrudRepository<BaixaAutomaticaDetalhe, BaixaAutomaticaDetalheId>,
BaixaAutomaticaDetalheRepositoryCustom {
    @Query(value="select count(*) inconsistencia from tribbaixaautomaticadetalhe bad inner join tribtipomensagem tm on tm.tipomensagem = bad.tipomensagem where bad.entidade = :entidade and bad.exercicio = :exercicio and bad.lote = :lote and tm.classificacao not in('c','p') and tm.tipomensagem <> 14", nativeQuery=true)
    public Long countInconsistenciasLote(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="lote") Long var3);

    public List<BaixaAutomaticaDetalhe> findByPagamentoLote(PagamentoLote var1);

    @Query(value="select new br.com.elotech.tributos.dto.TotalizadoresBaixaAutomaticaDTO(sum(t.valor),sum(t.valorPago))       from BaixaAutomaticaDetalhe t       where t.pagamentoLote.id = :pagamentoLoteId")
    public TotalizadoresBaixaAutomaticaDTO findValoresByPagamentoLoteId(@Param(value="pagamentoLoteId") PagamentoLoteId var1);

    @Query(value="select distinct bad.boleto          from BaixaAutomaticaDetalhe bad         where substring(bad.detalhe, 462, 17) = :sequencia           and bad.situacao in (br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem.PAGO, br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem.CREDITO_CONTRIBUINTE) ")
    public Optional<Bloqueto> getBoletoPagoSuperSimples(@Param(value="sequencia") String var1);

    @Query(value="select CASE when count(*) > 0 THEN false ELSE true  end  from BaixaAutomaticaDetalhe bad where bad.id.entidade = :entidade  and bad.id.exercicio = :exercicio  and bad.id.lote = :lote  and bad.situacao <> br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem.PAGO ")
    public Boolean todasSequenciasBaixadas(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="lote") Long var3);

    public boolean existsByBoleto(Bloqueto var1);

    @Query(value="select coalesce(max(bad.id.sequenciaArquivo),0) from BaixaAutomaticaDetalhe bad where bad.pagamentoLote.id = :idLote")
    public Long getUltimaSequenciaLote(@Param(value="idLote") PagamentoLoteId var1);
}

