/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.dto.PagamentoNegociadoDebitoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class PagamentoNegociadoDTO {
    private Long id;
    private LocalDate dataNegociacao;
    private String tipoCadastro;
    private String cadastroGeral;
    private BigDecimal valorNegociacao = BigDecimal.ZERO;
    private String situacao;
    private String observacao;
    private List<PagamentoNegociadoDebitoDTO> debitosOrigem;
    private List<PagamentoNegociadoDebitoDTO> debitosNovos;

    public static PagamentoNegociadoDTO from(PagamentoNegociado pagamento) {
        PagamentoNegociadoDTO dto = new PagamentoNegociadoDTO();
        Optional.ofNullable(pagamento.getId()).ifPresent(arg_0 -> dto.setId(arg_0));
        Optional.ofNullable(pagamento.getDataNegociacao()).ifPresent(arg_0 -> dto.setDataNegociacao(arg_0));
        Optional.ofNullable(pagamento.getTipoCadastrofiltro()).ifPresent(arg_0 -> dto.setTipoCadastro(arg_0));
        Optional.ofNullable(pagamento.getCadastroGeralfiltro()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(pagamento.getValorNegociado()).ifPresent(arg_0 -> dto.setValorNegociacao(arg_0));
        Optional.ofNullable(pagamento.getCancelado()).map(PagamentoNegociadoSituacaoEnum::getDescricao).ifPresent(arg_0 -> dto.setSituacao(arg_0));
        Optional.ofNullable(pagamento.getObservacao()).ifPresent(arg_0 -> dto.setObservacao(arg_0));
        return dto;
    }

    @Generated
    public PagamentoNegociadoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataNegociacao() {
        return this.dataNegociacao;
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public BigDecimal getValorNegociacao() {
        return this.valorNegociacao;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<PagamentoNegociadoDebitoDTO> getDebitosOrigem() {
        return this.debitosOrigem;
    }

    @Generated
    public List<PagamentoNegociadoDebitoDTO> getDebitosNovos() {
        return this.debitosNovos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataNegociacao(LocalDate dataNegociacao) {
        this.dataNegociacao = dataNegociacao;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setValorNegociacao(BigDecimal valorNegociacao) {
        this.valorNegociacao = valorNegociacao;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setDebitosOrigem(List<PagamentoNegociadoDebitoDTO> debitosOrigem) {
        this.debitosOrigem = debitosOrigem;
    }

    @Generated
    public void setDebitosNovos(List<PagamentoNegociadoDebitoDTO> debitosNovos) {
        this.debitosNovos = debitosNovos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociadoDTO)) {
            return false;
        }
        PagamentoNegociadoDTO other = (PagamentoNegociadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        LocalDate this$dataNegociacao = this.getDataNegociacao();
        LocalDate other$dataNegociacao = other.getDataNegociacao();
        if (this$dataNegociacao == null ? other$dataNegociacao != null : !((Object)this$dataNegociacao).equals(other$dataNegociacao)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        BigDecimal this$valorNegociacao = this.getValorNegociacao();
        BigDecimal other$valorNegociacao = other.getValorNegociacao();
        if (this$valorNegociacao == null ? other$valorNegociacao != null : !((Object)this$valorNegociacao).equals(other$valorNegociacao)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        List this$debitosOrigem = this.getDebitosOrigem();
        List other$debitosOrigem = other.getDebitosOrigem();
        if (this$debitosOrigem == null ? other$debitosOrigem != null : !((Object)this$debitosOrigem).equals(other$debitosOrigem)) {
            return false;
        }
        List this$debitosNovos = this.getDebitosNovos();
        List other$debitosNovos = other.getDebitosNovos();
        return !(this$debitosNovos == null ? other$debitosNovos != null : !((Object)this$debitosNovos).equals(other$debitosNovos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        LocalDate $dataNegociacao = this.getDataNegociacao();
        result = result * 59 + ($dataNegociacao == null ? 43 : ((Object)$dataNegociacao).hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        BigDecimal $valorNegociacao = this.getValorNegociacao();
        result = result * 59 + ($valorNegociacao == null ? 43 : ((Object)$valorNegociacao).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        List $debitosOrigem = this.getDebitosOrigem();
        result = result * 59 + ($debitosOrigem == null ? 43 : ((Object)$debitosOrigem).hashCode());
        List $debitosNovos = this.getDebitosNovos();
        result = result * 59 + ($debitosNovos == null ? 43 : ((Object)$debitosNovos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociadoDTO(id=" + this.getId() + ", dataNegociacao=" + this.getDataNegociacao() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", valorNegociacao=" + this.getValorNegociacao() + ", situacao=" + this.getSituacao() + ", observacao=" + this.getObservacao() + ", debitosOrigem=" + this.getDebitosOrigem() + ", debitosNovos=" + this.getDebitosNovos() + ")";
    }
}

