/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.Zoneamento;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBIMOBILIARIOTESTADA")
@Audited
public class CadastroImobiliarioTestada
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOTESTADA_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="idlogradourotestada", referencedColumnName="idlogradourotestada")
    @JsonIgnoreProperties(value={"logradouroTrecho", "setorTrechoInicial", "delimitacaoInicial", "setorTrechoFinal", "delimitacaoFinal", "logradouroTrechoInicial", "logradouroTrechoFinal", "lado", "logradouroTestadaExercicios"})
    @DiffRevisionIgnoreProperties(value={"faceQuadra", "logradouroInicial", "logradouroFinal", "quadraOposta", "exclusaoLogica", "quadricula", "respostasLogradouro", "setorQuadra"})
    @Caption(value="Logradouro Testada")
    private LogradouroTestada logradouroTestada;
    @Caption(value="Tamanho da Testada")
    private BigDecimal tamanhoTestada = BigDecimal.ZERO;
    @Caption(value="Tamanho Adicional")
    private BigDecimal tamanhoAdicional = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @Column(length=10)
    @Caption(value="N\u00famero")
    private String numero;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Utiliza Para C\u00e1lculo")
    private Boolean utilizaParaCalculo = Boolean.TRUE;
    @ManyToOne
    @JoinColumn(name="ideixo", referencedColumnName="ideixo")
    @Caption(value="Eixo")
    private Eixo eixo;
    @ManyToOne
    @JoinColumn(name="idzoneamento", referencedColumnName="idzoneamento")
    @Caption(value="Zoneamento")
    private Zoneamento zoneamento;
    @Caption(value="Guias Rebaixadas")
    private Long guiasRebaixadas;
    @Caption(value="Tamanho Guia Rebaixada")
    private BigDecimal tamanhoGuiaRebaixada = BigDecimal.ZERO;

    @DiffRevisionIgnore
    public Long getIdLogradouroTestada() {
        return this.logradouroTestada.getId();
    }

    public void merge(CadastroImobiliarioTestada testada) {
        this.logradouroTestada = testada.getLogradouroTestada();
        this.tamanhoTestada = testada.getTamanhoTestada();
        this.tamanhoAdicional = testada.getTamanhoAdicional();
        this.principal = testada.getPrincipal();
        this.numero = testada.getNumero();
        this.utilizaParaCalculo = testada.getUtilizaParaCalculo();
        this.eixo = testada.getEixo();
        this.zoneamento = testada.getZoneamento();
    }

    public CadastroImobiliarioTestada copy() {
        CadastroImobiliarioTestada testada = new CadastroImobiliarioTestada();
        BeanUtils.copyProperties((Object)this, (Object)testada, (String[])new String[]{"id"});
        return testada;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioTestada(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioTestada)) {
            return false;
        }
        CadastroImobiliarioTestada other = (CadastroImobiliarioTestada)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioTestada;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public CadastroImobiliarioTestada() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LogradouroTestada getLogradouroTestada() {
        return this.logradouroTestada;
    }

    @Generated
    public BigDecimal getTamanhoTestada() {
        return this.tamanhoTestada;
    }

    @Generated
    public BigDecimal getTamanhoAdicional() {
        return this.tamanhoAdicional;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public Boolean getUtilizaParaCalculo() {
        return this.utilizaParaCalculo;
    }

    @Generated
    public Eixo getEixo() {
        return this.eixo;
    }

    @Generated
    public Zoneamento getZoneamento() {
        return this.zoneamento;
    }

    @Generated
    public Long getGuiasRebaixadas() {
        return this.guiasRebaixadas;
    }

    @Generated
    public BigDecimal getTamanhoGuiaRebaixada() {
        return this.tamanhoGuiaRebaixada;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLogradouroTestada(LogradouroTestada logradouroTestada) {
        this.logradouroTestada = logradouroTestada;
    }

    @Generated
    public void setTamanhoTestada(BigDecimal tamanhoTestada) {
        this.tamanhoTestada = tamanhoTestada;
    }

    @Generated
    public void setTamanhoAdicional(BigDecimal tamanhoAdicional) {
        this.tamanhoAdicional = tamanhoAdicional;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setUtilizaParaCalculo(Boolean utilizaParaCalculo) {
        this.utilizaParaCalculo = utilizaParaCalculo;
    }

    @Generated
    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    @Generated
    public void setZoneamento(Zoneamento zoneamento) {
        this.zoneamento = zoneamento;
    }

    @Generated
    public void setGuiasRebaixadas(Long guiasRebaixadas) {
        this.guiasRebaixadas = guiasRebaixadas;
    }

    @Generated
    public void setTamanhoGuiaRebaixada(BigDecimal tamanhoGuiaRebaixada) {
        this.tamanhoGuiaRebaixada = tamanhoGuiaRebaixada;
    }
}

