/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornolancamentocredito;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class EstornoLancamentoCreditoJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoLancamentoCreditoJobListener.class);
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String JOB_TYPE = "jobType";
    private static final String ESTORNO_LANCAMENTO_CREDITO = JobType.SIMAM_ESTORNO_LANCAMENTO_CREDITO.getTipo();
    private final NotificacaoClient notificacaoClient;

    public EstornoLancamentoCreditoJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao notificacao = Notificacao.builder().text("SIM-AM - Estorno de Lan\u00e7amento de Cr\u00e9dito iniciado").title(String.format("Foi iniciada a gera\u00e7\u00e3o de dados Estorno de Lan\u00e7amento de Cr\u00e9dito - %s -> %s", dataInicial.toString(), dataFinal.toString())).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)ESTORNO_LANCAMENTO_CREDITO).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("SIM-AM - Estorno de Lan\u00e7amento de Cr\u00e9dito finalizado com sucesso").title(String.format("Os dados referentes ao Estorno de Lan\u00e7amento de Cr\u00e9dito no per\u00edodo %s -> %s foram gerados com sucesso.", dataInicial.toString(), dataFinal.toString())).metadata(JOB_TYPE, (Object)ESTORNO_LANCAMENTO_CREDITO).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Estorno de Lan\u00e7amento de Cr\u00e9dito").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)ESTORNO_LANCAMENTO_CREDITO).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

