/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito.dividaativa;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class EstornoDeducaoCreditoDividaAtivaJobListener
extends JobExecutionListenerSupport {
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String JOB_TYPE = "jobType";
    private static final String ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA_TIPO = JobType.SIMAM_ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA.getTipo();
    private static final String ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA = "SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - ";
    private final NotificacaoClient notificacaoClient;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao notificacao = Notificacao.builder().text(String.format("Iniciada a gera\u00e7\u00e3o de dados de Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa para a entidade %s - %s -> %s", entidade, dataInicial.toString(), dataFinal.toString())).title(ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA_TIPO).metadata(ENTIDADE, (Object)entidade).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text(String.format("Os dados referentes aos Estornos Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa da entidade %d foram gerados com sucesso.", entidade)).title("SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - finalizado com sucesso").metadata(JOB_TYPE, (Object)ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA_TIPO).metadata(ENTIDADE, (Object)entidade).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("N\u00e3o foi poss\u00edvel gerar os dados.").title("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - ").metadata(JOB_TYPE, (Object)ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA_TIPO).metadata(ENTIDADE, (Object)entidade).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    @Generated
    public EstornoDeducaoCreditoDividaAtivaJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }
}

