/*Cancelamento*/
select
        a.idtcededucaocreditoda as id,
        a.nrdeducao,
        a.nranodeducao,
        a.nrDivida,
        a.nrAnoDivida,
        a.idtipodeducaocredito,
        a.cdControleLeiAto,
        a.dtdeducao,
        case
            when count(distinct md.motivodesconto) > 1 then 'Motivos: ' || listagg(cast(md.motivodesconto as varchar(10)),',') WITHIN GROUP (ORDER BY cd.motivo)
    else listagg(substr(md.descricao || '. ' || coalesce(cd.motivo, ''), 0, 250),',') WITHIN GROUP (ORDER BY cd.motivo)
end as dsMotivo,
       sum(coalesce(tcdi.valorAtualizado, tcdi.valor)) as valor
from tcededucaocreditoda a
join tcededucaocancelamentoda b
 on a.idtcededucaocreditoda = b.idtcededucaocreditoda
join tribcancelamentodebitoitem tcdi
 on tcdi.entidade = b.entidade
and tcdi.exercicio = b.exercicio
and tcdi.idcancelamento = b.idcancelamento
and tcdi.iddebitoparcelareceita = b.iddebitoparcelareceita
join tribcancelamentodebito cd
 on cd.entidade = tcdi.entidade
and cd.exercicio = tcdi.exercicio
and cd.idcancelamento = tcdi.idcancelamento
left join tribmotivodesconto md
 on md.motivodesconto = cd.motivocancelamento
left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic
 on tdic.iddebitoparcelareceitaDestino = b.iddebitoparcelareceita
where (cd.datacancelamento between :dataInicial and :dataFinal) and cd.entidade = :entidade
group by a.nrAnoDivida, a.nrdivida, a.idtipodeducaocredito, a.cdControleLeiAto, a.dtdeducao,
         a.idtcededucaocreditoda, a.nrdeducao, a.nranodeducao
union all
/*Pagamento*/
select distinct
        a.idtcededucaocreditoda as id,
        a.nrdeducao,
        a.nranodeducao,
        a.nrDivida,
        a.nrAnoDivida,
        a.idtipodeducaocredito,
        a.cdControleLeiAto,
        a.dtdeducao,
        case
            when count(distinct tpb.motivodesconto) > 1 then 'Motivos: ' || listagg(cast(tpb.motivodesconto as varchar(10)),',') WITHIN GROUP (ORDER BY tpb.motivodesconto)
    else listagg(substr(md.descricao  || '. ' || coalesce(tbad.observacao, ''), 0, 250),',') WITHIN GROUP (ORDER BY tpb.motivodesconto)
end as dsMotivo,
       sum(tpd.valordesconto) as valor
from tcededucaocreditoda a
join tcededucaopagamentoda b
 on a.idtcededucaocreditoda = b.idtcededucaocreditoda
join tribpagamentodebito tpd
 on tpd.idpagamentobloqueto  = b.idpagamentobloqueto
and tpd.iddebitoparcelareceita = b.iddebitoparcelareceita
join tribpagamentobloqueto tpb
 on tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto
join tribpagamento tp
 on tp.entidade = tpb.entidade
and tp.exerciciopagamento = tpb.exerciciopagamento
and tp.pagamento = tpb.pagamento
left join tribbaixaautomaticadetalhe tbad
 on tbad.entidade = tp.entidade
and tbad.exerciciopagamento = tp.exerciciopagamento
and tbad.pagamento = tp.pagamento
left join tribmotivodesconto md
 on md.motivodesconto = tpb.motivodesconto
left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic
 on tdic.iddebitoparcelareceitaDestino = b.iddebitoparcelareceita
where tp.datalancamento between :dataInicial and :dataFinal and tp.entidade = :entidade
group by a.nrAnoDivida, a.nrdivida, a.idtipodeducaocredito, a.cdControleLeiAto, a.dtdeducao,
         a.idtcededucaocreditoda, a.nrdeducao, a.nranodeducao
union all
/*Crédito*/
select distinct
        a.idtcededucaocreditoda as id,
        a.nrdeducao,
        a.nranodeducao,
        a.nrDivida,
        a.nrAnoDivida,
        a.idtipodeducaocredito,
        a.cdControleLeiAto,
        a.dtdeducao,
        case
            when count(distinct md.motivodesconto) > 1 then 'Motivos: ' || listagg(cast(md.motivodesconto as varchar(10)),',') WITHIN GROUP (ORDER BY md.motivodesconto)
    else listagg(substr(md.descricao, 0, 250),',') WITHIN GROUP (ORDER BY md.motivodesconto)
end as dsMotivo,
       sum(tcci.valordesconto) as valor
from tcededucaocreditoda a
join tcededucaocreditocreditoda b
 on a.idtcededucaocreditoda = b.idtcededucaocreditoda
join tribCreditoContribuinteItem tcci
 on tcci.idcreditocontribuinteitem = b.idcreditocontribuinteitem
join tribcreditocontribuinte tcc
 on tcci.entidade = tcc.entidade
and tcci.exercicio = tcc.exercicio
and tcci.creditocontribuinte = tcc.creditocontribuinte
join tribdebitoparcelareceita tdpr
 on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
join tribbaixaautomaticadetalhe tbad
 on tcc.entidade = tbad.entidade
and tcc.exercicio = tbad.exerciciocredito
and tcc.creditocontribuinte = tbad.creditocontribuinte
join tribbloqueto tb
 on tb.entidade = tbad.entidade
and tb.exerciciobloqueto = tbad.exerciciobloqueto
and tb.bloqueto = tbad.bloqueto
join tribGuiaRecolhimentoFormaPag tgrfp
 on tgrfp.entidade = tdpr.entidade
and tgrfp.exercicio = tdpr.exercicio
and tgrfp.guiarecolhimento = tdpr.guiarecolhimento
and tgrfp.formapagamento = tb.formapagamento
left join tribMotivoDesconto md
 on md.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic
 on tdic.iddebitoparcelareceitaDestino = b.iddebitoparcelareceita
where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
group by a.nrAnoDivida, a.nrdivida, a.idtipodeducaocredito, a.cdControleLeiAto, a.dtdeducao,
         a.idtcededucaocreditoda, a.nrdeducao, a.nranodeducao
order by 1