/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.config.CustomResponseErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    public static RestTemplate restTemplate = new RestTemplate();

    public static RestTemplate getRestTemplateComCertificado(byte[] certificado, String senhaCertificado) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        restTemplate.setErrorHandler((ResponseErrorHandler)new CustomResponseErrorHandler());
        if (Objects.isNull(certificado)) {
            return restTemplate;
        }
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        clientStore.load(new ByteArrayInputStream(certificado), senhaCertificado.toCharArray());
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        sslContextBuilder.setProtocol("TLS");
        sslContextBuilder.loadKeyMaterial(clientStore, senhaCertificado.toCharArray());
        sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build());
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout(5000);
        requestFactory.setReadTimeout(30000);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }
}

