/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.itau;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.GerarQrCodePixItauRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.QrCodePixItauErroDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class IntegracaoBoletoItauService
implements IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoItauService.class);
    private static String ITAU_FLOW_ID = "f68492aa-81ed-4de2-8447-54ff780717a0";
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ParametroGeralService parametroGeralService;
    private final ParametroPixRepository parametroPixRepository;
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final ConfigurableEnvironment configurableEnvironment;

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto bloqueto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            Validate.notNull((Object)bloqueto, (String)"O boleto \u00e9 obrigat\u00f3rio para gerar o qrcode do pix.");
            integracaoBoletoPixLog.setBloqueto(bloqueto.getId());
            log.debug("IdBoleto {}: Iniciando processo para login na api", (Object)bloqueto.getId());
            String txid = this.gerarTxid(bloqueto.getModeloBloqueto().getConvenio().getChavePix());
            log.debug("IdBoleto {}: gerou o txId", (Object)bloqueto.getId());
            String url = String.format("%s/cobv/%s", this.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), txid);
            log.debug("idBoleto {}: criouUrl", (Object)bloqueto.getId());
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(bloqueto.getEntidade());
            log.debug("IdBoleto {}: Buscou o ParametroPix", (Object)bloqueto.getId());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            log.debug("IdBoleto {}: Buscou os dados do certificado", (Object)bloqueto.getId());
            String accessToken = this.getAccessToken(certificado, senhaCertificado, bloqueto.getId());
            HttpEntity requestEntity = this.createHeaders(accessToken, bloqueto);
            HttpMethod httpMethod = HttpMethod.PUT;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            integracaoBoletoPixLog.setUrlRequest(url);
            log.debug("IdBoleto {}: Montou o corpo da requisi\u00e7\u00e3o", (Object)bloqueto.getId());
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(url, httpMethod, requestEntity, JsonNode.class, new Object[0]).getBody();
            log.debug("IdBoleto {}: Retornou a requisi\u00e7\u00e3o", (Object)bloqueto.getId());
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            resultDto.setTextoQrCode(response.get("pixCopiaECola").asText());
            resultDto.setTxid(response.get("txid").asText());
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            QrCodePixItauErroDTO dtoErros = this.converteErroResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            log.debug("IdBoleto {}: Come\u00e7ou a salvar o log", (Object)bloqueto.getId());
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
            log.debug("IdBoleto {}: Terminou de salvar o log", (Object)bloqueto.getId());
        }
    }

    private HttpEntity<GerarQrCodePixItauRequestDTO> createHeaders(String accessToken, Bloqueto bloqueto) {
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        log.debug("IdBoleto {}: Buscou o clientId", (Object)bloqueto.getId());
        GerarQrCodePixItauRequestDTO dto = GerarQrCodePixItauRequestDTO.from((Bloqueto)bloqueto);
        log.debug("IdBoleto {}: Montou a requisi\u00e7\u00e3o", (Object)bloqueto.getId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy")) {
            headers.set("Authorization", String.format("Bearer %s", accessToken));
        } else {
            headers.set("x-sandbox-token", accessToken);
        }
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        headers.set("x-itau-apikey", clientId);
        log.debug("IdBoleto {}: Montou os headers", (Object)bloqueto.getId());
        return new HttpEntity((Object)dto, (MultiValueMap)headers);
    }

    public IntegracaoBoletoPixLog updateCodigoBarrasBoleto(CodigoBarrasQrCodePixItauDTO boleto) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.ALTERA_CODIGO_BARRAS_QR_CODE);
        try {
            Validate.notNull((Object)boleto, (String)"O boleto \u00e9 obrigat\u00f3rio para fazer a altera\u00e7\u00e3o");
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            String txid = boleto.getTxid();
            String url = String.format("%s/cobv/%s", this.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), txid);
            GerarQrCodePixItauRequestDTO dto = GerarQrCodePixItauRequestDTO.alteracaoQrCodePixItau((CodigoBarrasQrCodePixItauDTO)boleto);
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            HttpMethod httpMethod = HttpMethod.PATCH;
            HttpHeaders headers = this.getHttpHeaders(certificado, senhaCertificado, boleto.getId());
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setTxid(txid);
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(url, httpMethod, requestEntity, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            return integracaoBoletoPixLog;
        }
        catch (RestException e) {
            QrCodePixItauErroDTO dtoErros = this.converteErroResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
            throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private HttpHeaders getHttpHeaders(byte[] certificado, String senhaCertificado, Long idBoleto) throws JsonProcessingException {
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        String accessToken = this.getAccessToken(certificado, senhaCertificado, idBoleto);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        headers.set("x-itau-apikey", clientId);
        if (AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy")) {
            headers.set("Authorization", String.format("Bearer %s", accessToken));
        } else {
            headers.set("x-sandbox-token", accessToken);
        }
        return headers;
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(valor) || StringUtils.isEmpty((String)valor)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public String getAccessToken(byte[] certificado, String senhaCertificado, Long idBoleto) throws JsonProcessingException {
        IntegracaoTokenService tokenService = this.getTokenService("JWT");
        log.debug("IdBoleto {}: Buscando token", (Object)idBoleto);
        Optional accessToken = tokenService.getAccessToken(Banco.CODIGO_BANCO_ITAU, IntegracaoTokenOperation.BOLETO);
        if (accessToken.isPresent()) {
            log.debug("idBoleto {}: Token encontrado", (Object)idBoleto);
            return (String)accessToken.get();
        }
        log.debug("idBoleto {}: N\u00e3o h\u00e1 um token v\u00e1lido. Ser\u00e1 gerado um novo", (Object)idBoleto);
        String newAccessToken = this.generateNewAccessToken(certificado, senhaCertificado, idBoleto);
        log.debug("idBoleto {}: Token gerado. Salvando no banco para utiliza\u00e7\u00e3o", (Object)idBoleto);
        return tokenService.saveIntegracaoToken(Banco.CODIGO_BANCO_ITAU, IntegracaoTokenOperation.BOLETO, newAccessToken);
    }

    private String generateNewAccessToken(byte[] certificado, String senhaCertificado, Long idBoleto) {
        log.debug("IdBoleto {}: Iniciando gera\u00e7\u00e3o do Access Token", (Object)idBoleto);
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_URL);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTSECRET);
        log.debug("IdBoleto {}: Buscou os parametros para a  gera\u00e7\u00e3o do Access Token", (Object)idBoleto);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)clientId);
        body.add((Object)"client_secret", (Object)clientSecret);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                if (log.isDebugEnabled()) {
                    String responseString = Optional.ofNullable(response).map(Object::toString).orElse("A resposta veio nula");
                    log.debug("IdBoleto {}: Erro na resposta de gera\u00e7\u00e3o do token: {}", (Object)idBoleto, (Object)responseString);
                }
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
            return response.get("access_token").asText();
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
    }

    private String gerarTxid(String chave) {
        String dataHoraAtual = LocalDateTime.now().toString();
        return DigestUtils.md5Hex((String)(dataHoraAtual + chave));
    }

    private QrCodePixItauErroDTO converteErroResposta(String json) {
        try {
            return (QrCodePixItauErroDTO)this.mapper.readValue(json, QrCodePixItauErroDTO.class);
        }
        catch (JsonProcessingException e) {
            QrCodePixItauErroDTO erroDTO = new QrCodePixItauErroDTO();
            erroDTO.setTitle("Erro ao ler o json do retorno com erro. " + e.getMessage());
            return erroDTO;
        }
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_BANCO_ITAU;
    }

    private IntegracaoTokenService getTokenService(String tipoToken) {
        return this.integracaoTokenServices.stream().filter(s -> s.accept(tipoToken)).findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o encontrado service para lidar com o tipo de token %s", tipoToken)));
    }

    @Generated
    public IntegracaoBoletoItauService(ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ParametroGeralService parametroGeralService, ParametroPixRepository parametroPixRepository, List<IntegracaoTokenService> integracaoTokenServices, ConfigurableEnvironment configurableEnvironment) {
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.parametroGeralService = parametroGeralService;
        this.parametroPixRepository = parametroPixRepository;
        this.integracaoTokenServices = integracaoTokenServices;
        this.configurableEnvironment = configurableEnvironment;
    }
}

