/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cancelamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.CancelamentoDebitoDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.repository.cancelamento.CancelamentoDebitoRepository;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoTributoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class EstornoCancelamentoDebitoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoCancelamentoDebitoService.class);
    private static final Integer MAX_WIDTH_OBSERVACAO = 1000;
    private final CancelamentoDebitoRepository cancelamentoDebitoRepository;
    private final DebitoTributoService debitoTributoService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public EstornoCancelamentoDebitoService(CancelamentoDebitoRepository cancelamentoDebitoRepository, DebitoTributoService debitoTributoService, SituacaoParcelaService situacaoParcelaService, DebitoObservacaoService debitoObservacaoService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.cancelamentoDebitoRepository = cancelamentoDebitoRepository;
        this.debitoTributoService = debitoTributoService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }

    public CancelamentoDebitoDTO estornarPorParcela(CancelamentoDebitoPk cancelamentoDebitoPk, List<CancelamentoDebitoParcelaDTO> parcelas) {
        CancelamentoDebito cancelamentoDebito = this.getCancelamentoDebito(cancelamentoDebitoPk);
        ArrayList tributos = new ArrayList();
        parcelas.forEach(parcela -> cancelamentoDebito.getItens().stream().filter(arg_0 -> ((CancelamentoDebitoParcelaDTO)parcela).equalsCancelamentoDebitoItem(arg_0)).forEach(cancelamentoDebitoItem -> {
            CancelamentoDebitoTributoDTO tributo = CancelamentoDebitoTributoDTO.from((CancelamentoDebitoItem)cancelamentoDebitoItem);
            tributo.setObservacao(parcela.getObservacao());
            tributo.setIdProcesso(parcela.getIdProcesso());
            tributo.setExercicioProcesso(parcela.getExercicioProcesso());
            tributos.add(tributo);
        }));
        return this.estornar(cancelamentoDebito, tributos, Boolean.FALSE);
    }

    public CancelamentoDebitoDTO estornarPorTributo(CancelamentoDebitoPk cancelamentoDebitoPk, List<CancelamentoDebitoTributoDTO> tributos) {
        CancelamentoDebito cancelamentoDebito = this.getCancelamentoDebito(cancelamentoDebitoPk);
        return this.estornar(cancelamentoDebito, tributos, Boolean.TRUE);
    }

    private CancelamentoDebitoDTO estornar(CancelamentoDebito cancelamentoDebito, List<CancelamentoDebitoTributoDTO> tributos, Boolean porTributo) {
        if (this.cancelamentoDebitoRepository.possuiCadastroComExclusaoLogica(cancelamentoDebito.getId().getEntidade(), cancelamentoDebito.getId().getExercicio(), cancelamentoDebito.getId().getId()).booleanValue()) {
            throw new EloValidationException("Este cancelamento n\u00e3o pode ser estornado por possuir d\u00e9bito(s) de cadastro(s) em Exclus\u00e3o L\u00f3gica");
        }
        this.validaDataMovimentacaoService.validaMesEDia(cancelamentoDebito.getId().getEntidade(), LocalDate.now());
        String usuario = UsuarioUtils.getUsuarioAise();
        tributos.forEach(tributo -> cancelamentoDebito.getItens().stream().filter(arg_0 -> ((CancelamentoDebitoTributoDTO)tributo).equalsCancelamentoDebitoItem(arg_0)).findFirst().ifPresent(cancelamentoDebitoItem -> {
            if (Strings.isBlank((String)tributo.getObservacao())) {
                throw new RestException(HttpStatus.BAD_REQUEST, "O motivo do estorno do cancelamento \u00e9 obrigat\u00f3rio.");
            }
            cancelamentoDebitoItem.setEstornado(Boolean.TRUE);
            cancelamentoDebitoItem.setUsuarioEstorno(usuario);
            cancelamentoDebitoItem.setDataEstorno(LocalDate.now());
            cancelamentoDebitoItem.setProgramaEstorno("Oxy-Tributos");
            cancelamentoDebitoItem.setObservacao(StringUtils.abbreviate((String)tributo.getObservacao(), (int)MAX_WIDTH_OBSERVACAO));
            cancelamentoDebitoItem.setIdProcesso(tributo.getIdProcesso());
            cancelamentoDebitoItem.setExercicioProcesso(tributo.getExercicioProcesso());
            if (porTributo.booleanValue()) {
                this.updateValoresDebito(cancelamentoDebitoItem);
            } else {
                DebitoParcela debitoParcela = cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getDebitoParcela();
                if (!debitoParcela.getSituacaoDebito().isAberto().booleanValue()) {
                    debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.INSCRICAO, debitoParcela.getSituacaoDebito()));
                }
            }
        }));
        this.cancelamentoDebitoRepository.save((Object)cancelamentoDebito);
        this.addObservacaoCancelamento(cancelamentoDebito, tributos);
        return CancelamentoDebitoDTO.from((CancelamentoDebito)cancelamentoDebito);
    }

    private CancelamentoDebito getCancelamentoDebito(CancelamentoDebitoPk cancelamentoDebitoPk) {
        CancelamentoDebito cancelamentoDebito = (CancelamentoDebito)this.cancelamentoDebitoRepository.findById((Object)cancelamentoDebitoPk).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("Cancelamento de d\u00e9bito n\u00e3o encontrado. Entidade: %d, Exerc\u00edcio: %d, IdCancelamento: %d.", cancelamentoDebitoPk.getEntidade(), cancelamentoDebitoPk.getExercicio(), cancelamentoDebitoPk.getId())));
        if (Objects.isNull(cancelamentoDebito.getPorTributo())) {
            throw new RestException(HttpStatus.NOT_FOUND, "N\u00e3o \u00e9 poss\u00edvel concluir a opera\u00e7\u00e3o por falta de dados.");
        }
        return cancelamentoDebito;
    }

    private void updateValoresDebito(CancelamentoDebitoItem cancelamentoDebitoItem) {
        this.updateDebitoTributo(cancelamentoDebitoItem);
        this.updateDebitoParcelaTributo(cancelamentoDebitoItem);
    }

    private void updateDebitoTributo(CancelamentoDebitoItem cancelamentoDebitoItem) {
        DebitoParcelaTributo debitoParcelaTributo = cancelamentoDebitoItem.getId().getDebitoParcelaTributo();
        DebitoTributo debitoTributo = (DebitoTributo)this.debitoTributoService.findOne((Serializable)DebitoTributoId.of((DebitoParcelaTributo)debitoParcelaTributo));
        debitoTributo.setValorRenuncia(debitoTributo.getValorRenuncia().subtract(cancelamentoDebitoItem.getValor()));
        this.debitoTributoService.save((EloEntity)debitoTributo, null);
        LOGGER.info("Estornado valor ren\u00fancia do d\u00e9bito tributo. {}", (Object)debitoTributo);
    }

    private void updateDebitoParcelaTributo(CancelamentoDebitoItem cancelamentoDebitoItem) {
        DebitoParcelaTributo debitoParcelaTributo = cancelamentoDebitoItem.getId().getDebitoParcelaTributo();
        debitoParcelaTributo.setValor(debitoParcelaTributo.getValor().add(cancelamentoDebitoItem.getValor()));
        if (!debitoParcelaTributo.getDebitoParcela().getSituacaoDebito().isAberto().booleanValue()) {
            debitoParcelaTributo.getDebitoParcela().setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.INSCRICAO, debitoParcelaTributo.getDebitoParcela().getSituacaoDebito()));
        }
        LOGGER.info("D\u00e9bito parcela com situa\u00e7\u00e3o Aberto salvo. {}", (Object)debitoParcelaTributo);
    }

    private void addObservacaoCancelamento(CancelamentoDebito cancelamentoDebito, List<CancelamentoDebitoTributoDTO> tributos) {
        Map debitos = CancelamentoDebitoTributoDTO.getItensCanceladosByDebitos(tributos);
        debitos.forEach((debitoIdDTO, listaCancelamentoDebitoTributoDTO) -> {
            String parcelas = listaCancelamentoDebitoTributoDTO.stream().map(CancelamentoDebitoTributoDTO::getParcela).distinct().sorted().map(Object::toString).collect(Collectors.joining(","));
            this.debitoObservacaoService.save(debitoIdDTO, String.format("Estorno de cancelamento de d\u00e9bito n\u00famero %d/%d. Parcela(s) %s.", cancelamentoDebito.getId().getId(), cancelamentoDebito.getId().getExercicio(), parcelas));
        });
    }
}

