/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.tarefaassincrona.SituacaoTarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.repository.TarefaAssincronaExecucaoRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TarefaAssincronaExecucaoService
extends CrudService<TarefaAssincronaExecucao, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarefaAssincronaExecucaoService.class);
    private final TarefaAssincronaExecucaoRepository tarefaAssincronaExecucaoRepository;

    public TarefaAssincronaExecucaoService(TarefaAssincronaExecucaoRepository tarefaAssincronaExecucaoRepository) {
        this.tarefaAssincronaExecucaoRepository = tarefaAssincronaExecucaoRepository;
    }

    @Transactional
    public void invalidarExecucoesProcessando() {
        List execucoes = this.tarefaAssincronaExecucaoRepository.findExecucoesProcessando();
        LOGGER.info("Foram encontradas {} execu\u00e7\u00f5es processando de tarefas ass\u00edncronas", (Object)execucoes.size());
        execucoes.forEach(execucao -> {
            LOGGER.info("Altera\u00e7\u00e3o da situa\u00e7\u00e3o da execu\u00e7\u00e3o {} para {} pois n\u00e3o foi finalizado anteriormente", (Object)execucao.getId(), (Object)SituacaoTarefaAssincrona.ERRO.getDescricao());
            execucao.setSituacao(SituacaoTarefaAssincrona.ERRO);
            execucao.setMensagemErro("Processamento interrompido de forma inesperada. Tente novamente.");
            execucao.setDataFim(LocalDateTime.now());
            this.save((EloEntity)execucao, null);
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public TarefaAssincronaExecucao criarNovaExecucao(TarefaAssincrona tarefa) {
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        execucao.setTarefaAssincrona(tarefa);
        this.save((EloEntity)execucao, null);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public TarefaAssincronaExecucao marcarExecucaoComErro(TarefaAssincronaExecucao execucao, String mensagemErro) {
        execucao.setSituacao(SituacaoTarefaAssincrona.ERRO);
        execucao.setMensagemErro(mensagemErro);
        execucao.setDataFim(LocalDateTime.now());
        return (TarefaAssincronaExecucao)this.save((EloEntity)execucao, null);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public TarefaAssincronaExecucao finalizarExecucao(TarefaAssincronaExecucao execucao) {
        execucao.setSituacao(SituacaoTarefaAssincrona.FINALIZADO);
        execucao.setDataFim(LocalDateTime.now());
        return (TarefaAssincronaExecucao)this.save((EloEntity)execucao, null);
    }
}

