/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.ComunicadoDTO;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ComunicadoCadastroService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ComunicadoService
extends CrudService<Comunicado, ComunicadoId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComunicadoService.class);
    private final ComunicadoRepository comunicadoRepository;
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoClient notificacaoClient;
    private final ArquivoClient arquivoClientNovo;
    private final ArquivoClient arquivoClient;

    public Page<ComunicadoDTO> search(String search, Pageable pageable) {
        return this.findByRsql(search, pageable).map(ComunicadoDTO::from);
    }

    public void validateEnderecosGlobais(Long entidade, Long exercicio, Long idComunicado) throws Exception {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (SituacaoComunicado.CANCELADO.equals((Object)comunicado.getSituacao())) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
    }

    public Comunicado cancelComunicado(Long entidade, Long exercicio, Long idComunicado) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (SituacaoComunicado.CANCELADO.equals((Object)comunicado.getSituacao())) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
        this.comunicadoCadastroRepository.updateComunicadoCadastrosSituacao(entidade, exercicio, idComunicado, SituacaoComunicadoCadastro.CANCELADO, SituacaoComunicadoCadastro.CANCELADO.getDescricao());
        this.comunicadoRepository.updateComunicadoSituacaoCancelado(entidade, exercicio, idComunicado);
        comunicado.setSituacao(SituacaoComunicado.CANCELADO);
        return comunicado;
    }

    @Async
    @Transactional
    public void printLoteComunicado(Long entidade, Long exercicio, Long idComunicado, String search, Sort sort) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaImpressaoLoteComunicado(comunicadoId.toString());
        Long tarefa = execucao.getTarefaAssincrona().getId();
        String userId = SecurityUtils.getUserId().toString();
        this.sendNotificacao(String.format("Iniciada a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), tarefa, userId);
        List comunicadosCadastro = this.comunicadoCadastroService.findByRsql(entidade, exercicio, idComunicado, search, sort);
        this.groupArquivosLoteComunicado(comunicadosCadastro, comunicadoId, execucao, tarefa, userId);
    }

    public String getUrlArquivoLoteComunicado(Long entidade, Long exercicio, Long idComunicado) {
        try {
            Comunicado comunicado = (Comunicado)this.comunicadoRepository.findById((Object)ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comunicado n\u00e3o encontrado"));
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + comunicado.getIdArquivoImpressao()));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception ex) {
            throw new EloValidationException("Falha ao recuperar URL de download do arquivo." + ex.getMessage());
        }
    }

    private void groupArquivosLoteComunicado(List<ComunicadoCadastro> comunicadosCadastro, ComunicadoId comunicadoId, TarefaAssincronaExecucao execucao, Long tarefa, String userId) {
        if (Objects.isNull(comunicadosCadastro)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Lote de Comunicado de id %s.", comunicadoId.toString()));
        }
        try {
            log.info("Iniciando o agrupamento dos arquivos de Lote de Comunicado");
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequest(comunicadoId.toString(), comunicadosCadastro);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            comunicadosCadastro.forEach(comunicadoCadastro -> {
                comunicadoCadastro.getId().getComunicado().setIdArquivoImpressao(arquivo.getId());
                comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.IMPRESSO);
                comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.IMPRESSO.getDescricao());
            });
            this.comunicadoCadastroRepository.saveAll(comunicadosCadastro);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.sendNotificacao(String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), tarefa, userId);
            log.info("Finalizado o agrupamento dos arquivos de Lote de Comunicado e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.sendNotificacao(String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), tarefa, userId);
            log.error("Erro ao agrupar arquivos de Lote de Comunicado {} ", (Object)e.getMessage(), (Object)e);
        }
    }

    private ArquivoNovoRequest getArquivoNovoRequest(String comunicadoId, List<ComunicadoCadastro> comunicadosCadastro) throws IOException {
        InputStream inputStream = this.groupArquivosLoteComunicado(comunicadosCadastro);
        return this.uploadArquivoAgrupado(comunicadoId, inputStream);
    }

    private ArquivoNovoRequest uploadArquivoAgrupado(String comunicadoId, InputStream inputStream) {
        String nomeArquivo = String.format("Comunicado_Lote_%s_%s", comunicadoId, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
    }

    private InputStream groupArquivosLoteComunicado(List<ComunicadoCadastro> comunicadosCadastro) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        try (PDDocument document = new PDDocument();){
            for (ComunicadoCadastro comunicadoCadastro : comunicadosCadastro) {
                PDFMergerUtility pdfMerge = new PDFMergerUtility();
                byte[] arquivoTemp = this.comunicadoCadastroService.print(comunicadoCadastro.getId().getComunicado().getId().getEntidade(), comunicadoCadastro.getId().getComunicado().getId().getExercicio(), comunicadoCadastro.getId().getComunicado().getId().getIdComunicado(), comunicadoCadastro.getId().getSequencia());
                PDDocument pdfDocument = PDDocument.load((byte[])arquivoTemp);
                pdfMerge.appendDocument(document, pdfDocument);
                pdfDocument.close();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            document.save((OutputStream)byteArrayOutputStream);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private void sendNotificacao(String title, Long tarefa, String userId) {
        Notificacao notificacao = Notificacao.builder().title(title).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata("tipoTarefaAssincrona", (Object)TipoTarefaAssincrona.IMPRESSAO_COMUNICADO_LOTE).metadata("tarefa", (Object)tarefa).build();
        this.notificacaoClient.send(notificacao, UUID.fromString(userId));
    }

    private ArquivoClient resolveArquivoClient() {
        return TenantUtils.usesNovoS3() != false ? this.arquivoClientNovo : this.arquivoClient;
    }

    @Generated
    public ComunicadoService(ComunicadoRepository comunicadoRepository, ComunicadoCadastroRepository comunicadoCadastroRepository, ComunicadoCadastroService comunicadoCadastroService, TarefaAssincronaService tarefaAssincronaService, NotificacaoClient notificacaoClient, ArquivoClient arquivoClientNovo, ArquivoClient arquivoClient) {
        this.comunicadoRepository = comunicadoRepository;
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoClient = notificacaoClient;
        this.arquivoClientNovo = arquivoClientNovo;
        this.arquivoClient = arquivoClient;
    }
}

