/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Cnae;
import br.com.elotech.tributos.domain.CnaeServico;
import br.com.elotech.tributos.domain.Servico;
import java.util.HashSet;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CnaeService
extends CrudService<Cnae, Long> {
    protected void beforeSave(Cnae cnae, Authentication authentication) {
        cnae.getAtividadeMEIS().stream().forEach(item -> item.setCnae(cnae));
        cnae.getCnaeServico().stream().forEach(item -> item.setCnae(cnae));
        HashSet<Servico> servicoDuplicado = new HashSet<Servico>();
        for (CnaeServico cs : cnae.getCnaeServico()) {
            if (servicoDuplicado.add(cs.getServico())) continue;
            throw new EloValidationException("Duplica\u00e7\u00e3o nos servi\u00e7os da CNAE!");
        }
        super.beforeSave((EloEntity)cnae, authentication);
    }
}

