/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralPostGeomaisDTO;
import br.com.elotech.tributos.service.integracaogeomais.CadastroImobiliarioElogeoService;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/cadastro"})
public class CadastroGeralGeomaisResource {
    private final CadastroImobiliarioElogeoService cadastroImobiliarioElogeoService;

    public CadastroGeralGeomaisResource(CadastroImobiliarioElogeoService cadastroImobiliarioElogeoService) {
        this.cadastroImobiliarioElogeoService = cadastroImobiliarioElogeoService;
    }

    @ApiOperation(value="Retorna uma lista de todos os cadastros imobili\u00e1rios")
    @GetMapping
    public ResponseEntity<Page<CadastroGeralGeomaisDTO>> findAllDTO(Pageable page) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeoService.findAllGeomaisDTO(page));
    }

    @ApiOperation(value="Retorna um cadastro imobili\u00e1rio em espec\u00edfico")
    @GetMapping(value={"/imobiliario/{cadastroGeral}"})
    public ResponseEntity<CadastroGeralGeomaisDTO> findByCadastroGeralGeomaisDTO(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeoService.findByCadastroGeralGeomaisDTO(cadastroGeral));
    }

    @ApiOperation(value="Altera um cadastro imobili\u00e1rio existente")
    @PutMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroGeralGeomaisDTO> update(@PathVariable Long cadastroGeral, @RequestBody @Valid CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeoService.saveGeomaisDTO(cadastroGeralPostGeomaisDTO, Boolean.FALSE, cadastroGeral));
    }

    @ApiOperation(value="Grava um novo cadastro imobili\u00e1rio")
    @PostMapping
    public ResponseEntity<CadastroGeralGeomaisDTO> save(@RequestBody @Valid CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.cadastroImobiliarioElogeoService.saveGeomaisDTO(cadastroGeralPostGeomaisDTO, Boolean.TRUE, null));
    }
}

