/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.dto.FiltroPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoResumoDTO;
import br.com.elotech.tributos.service.PagamentoService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pagamentos"})
public class PagamentoResource
extends CrudResource<Pagamento, PagamentoId> {
    private final PagamentoService pagamentoService;

    public PagamentoResource(PagamentoService pagamentoService) {
        this.pagamentoService = pagamentoService;
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<Page<PagamentoDTO>> findAllPagamentos(@RequestBody FiltroPagamentoDTO filtro, Pageable page) {
        return ResponseEntity.ok((Object)this.pagamentoService.searchPagamentoDTO(filtro, page));
    }

    @GetMapping(value={"/resumo/{entidade}/{exercicioPagamento}/{pagamento}"})
    public ResponseEntity<PagamentoResumoDTO> getPagamentoById(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicioPagamento") Long exercicioPagamento, @PathVariable(value="pagamento") Long pagamento) {
        return ResponseEntity.ok((Object)this.pagamentoService.getPagamentoById(entidade, exercicioPagamento, pagamento));
    }
}

