/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.CadastroGeralImagem;
import br.com.elotech.tributos.dto.EloArquivoDTO;
import br.com.elotech.tributos.service.CadastroGeralImagemService;
import java.io.IOException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/cadastro-geral-imagem"})
public class CadastroGeralImagemResource
extends CrudResource<CadastroGeralImagem, Long> {
    private final CadastroGeralImagemService cadastroGeralImagemService;

    public CadastroGeralImagemResource(CadastroGeralImagemService cadastroGeralImagemService) {
        this.cadastroGeralImagemService = cadastroGeralImagemService;
    }

    @GetMapping(value={"/atualiza-arquivos"})
    public ResponseEntity<Void> updateArquivos() {
        this.cadastroGeralImagemService.updateEloArquivos();
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/arquivos"})
    public ResponseEntity<Page<EloArquivoDTO>> findArquivos(@PathVariable Long id, Pageable page) {
        return ResponseEntity.ok((Object)this.cadastroGeralImagemService.findArquivos(id, page));
    }

    @PostMapping(value={"/{id}/upload-arquivo"})
    public ResponseEntity<CadastroGeralImagem> uploadArquivo(@PathVariable Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.cadastroGeralImagemService.uploadArquivo(id, file));
    }

    @GetMapping(value={"/{id}/download-arquivo"})
    public ResponseEntity<String> downloadArquivo(@PathVariable Long id) throws IOException {
        return ResponseEntity.ok((Object)this.cadastroGeralImagemService.getUrlArquivo(id));
    }
}

