/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.DeducaoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.DeducaoCreditoDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.DeducaoCreditoMaDTO;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCustomRepository;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.support.DatabaseType;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DeducaoCreditoCustomRepositoryImpl
implements DeducaoCreditoCustomRepository {
    private final String sqlCargaExistentePostgres = FileUtils.readResourceAsString((String)"sql/simam/deducaoCreditoCargaExistente_postgres.sql");
    private final String sqlCargaExistenteOracle = FileUtils.readResourceAsString((String)"sql/simam/deducaoCreditoCargaExistente_oracle.sql");
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<DeducaoCreditoCargaExistenteDTO> getCargaExistenteDeducaoCredito(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        return this.namedParameterJdbcTemplate.query(this.getSqlCargaExistente(), (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DeducaoCreditoCargaExistenteDTO.class));
    }

    private String getSqlCargaExistente() {
        return DatabaseType.POSTGRES.equals((Object)SqlUtils.getDatabaseType((DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource())) ? this.sqlCargaExistentePostgres : this.sqlCargaExistenteOracle;
    }

    private String getSqlUpdateValorFinal() {
        return String.format("update tcededucaocredito up set vldeducao = (select sum(w.valor) from (%s) w where w.id = up.idtcededucaocredito),  dsMotivo = (select substr(w.dsmotivo, 0, 250) from (%s) w where w.id = up.idtcededucaocredito) where up.dtdeducao between :dataInicial and :dataFinal ", this.getSqlCargaExistente(), this.getSqlCargaExistente());
    }

    public void atualizaValorFinal(@Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        this.namedParameterJdbcTemplate.update(this.getSqlUpdateValorFinal(), (SqlParameterSource)parameters);
    }

    public void verificarErrors(@Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        String nrCreditoNaoLocalizado;
        List lista = this.getCargaExistenteDeducaoCredito(entidade, dataInicial, dataFinal);
        StringBuilder erros = new StringBuilder();
        String leiAtoNaoCadastrado = lista.stream().filter(item -> Objects.isNull(item.getCdControleLeiAto())).map(DeducaoCreditoCargaExistenteDTO::getId).map(Object::toString).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)leiAtoNaoCadastrado)) {
            erros.append("\n").append("Lei/Ato n\u00e3o localizado para os Ids: ").append(leiAtoNaoCadastrado);
        }
        if (StringUtils.isNotBlank((CharSequence)(nrCreditoNaoLocalizado = lista.stream().filter(item -> Objects.isNull(item.getNrCredito())).map(DeducaoCreditoCargaExistenteDTO::getId).map(Object::toString).collect(Collectors.joining(", "))))) {
            erros.append("\n").append("NrCredito n\u00e3o localizado para os Ids: ").append(nrCreditoNaoLocalizado);
        }
        if (StringUtils.isNotBlank((CharSequence)erros.toString())) {
            throw new EloValidationException(erros.toString());
        }
    }

    public List<DeducaoCreditoDTO> findLancamentos(@Param(value="idPessoa") Long idPessoa, @Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/deducaoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DeducaoCreditoDTO.class));
    }

    public List<DeducaoCreditoMaDTO> findLancamentosMa(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/manutencaoarquivo/deducaoCreditoMa.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DeducaoCreditoMaDTO.class));
    }

    @Generated
    public DeducaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

