/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class PagamentoNegociadoDebitoDTO {
    private Long idDebito;
    private Long entidade;
    private Long exercicio;
    private Long subDivida;
    private Long parcela;
    private Long guiaRecolhimento;
    private BigDecimal valor = BigDecimal.ZERO;

    public static PagamentoNegociadoDebitoDTO fromOrigem(PagamentoNegociadoDebOrigem origem) {
        PagamentoNegociadoDebitoDTO dto = new PagamentoNegociadoDebitoDTO();
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getDebito).map(Debito::getId).ifPresent(arg_0 -> dto.setIdDebito(arg_0));
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getId).map(DebitoParcelaId::getEntidade).ifPresent(arg_0 -> dto.setEntidade(arg_0));
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getId).map(DebitoParcelaId::getExercicio).ifPresent(arg_0 -> dto.setExercicio(arg_0));
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getId).map(DebitoParcelaId::getSubDivida).ifPresent(arg_0 -> dto.setSubDivida(arg_0));
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getId).map(DebitoParcelaId::getParcela).ifPresent(arg_0 -> dto.setParcela(arg_0));
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getId).map(DebitoParcelaId::getDivida).ifPresent(arg_0 -> dto.setGuiaRecolhimento(arg_0));
        Optional.ofNullable(origem.getValorTotal()).ifPresent(arg_0 -> dto.setValor(arg_0));
        return dto;
    }

    public static PagamentoNegociadoDebitoDTO from(PagamentoNegociadoDebNovo debito) {
        PagamentoNegociadoDebitoDTO dto = new PagamentoNegociadoDebitoDTO();
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getDebito).map(Debito::getId).ifPresent(arg_0 -> dto.setIdDebito(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getId).map(DebitoParcelaId::getEntidade).ifPresent(arg_0 -> dto.setEntidade(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getId).map(DebitoParcelaId::getExercicio).ifPresent(arg_0 -> dto.setExercicio(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getId).map(DebitoParcelaId::getSubDivida).ifPresent(arg_0 -> dto.setSubDivida(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getId).map(DebitoParcelaId::getParcela).ifPresent(arg_0 -> dto.setParcela(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getId).map(DebitoParcelaId::getDivida).ifPresent(arg_0 -> dto.setGuiaRecolhimento(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getValorTotal).ifPresent(arg_0 -> dto.setValor(arg_0));
        return dto;
    }

    @Generated
    public PagamentoNegociadoDebitoDTO() {
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociadoDebitoDTO)) {
            return false;
        }
        PagamentoNegociadoDebitoDTO other = (PagamentoNegociadoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$guiaRecolhimento = this.getGuiaRecolhimento();
        Long other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        return !(this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociadoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociadoDebitoDTO(idDebito=" + this.getIdDebito() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", valor=" + this.getValor() + ")";
    }
}

