/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.Assert;

@Entity
@Table(name="TribLoteamento")
public class Loteamento
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBLOTEAMENTO_ID")
    private Long id;
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="distrito", updatable=false)
    @JsonIgnoreProperties(value={"setores"})
    private Distrito distrito;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBSETOR_IDKEY", referencedColumnName="idkey", updatable=false)
    @JsonIgnoreProperties(value={"quadras"})
    @MetaModelIgnore
    private Setor setor;
    @Column(name="loteamento")
    @EloSequence(sequenceName="s05Loteamento")
    @Caption(value="C\u00f3digo")
    private Long loteamento;
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao")), @Field(name="loteamentoDescricao", analyze=Analyze.NO)})
    @Facet(name="loteamentoDescricao", forField="loteamentoDescricao")
    @Length(max=60)
    @Caption(value="Descri\u00e7\u00e3o")
    private @Length(max=60) String descricao;
    @ManyToOne
    @JoinColumn(name="loteador", referencedColumnName="pessoa")
    @Caption(value="Loteador")
    private Pessoa loteador;
    @ManyToOne
    @JoinColumn(name="proprietario", referencedColumnName="pessoa")
    @Caption(value="Propriet\u00e1rio")
    private Pessoa proprietario;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cidade", referencedColumnName="cidade"), @JoinColumn(name="bairro", referencedColumnName="bairro")})
    private Bairro bairro;
    @Length(max=60)
    @Caption(value="Apelido")
    private @Length(max=60) String apelido;
    @Caption(value="Numero Lotes")
    private Long numeroLotes;
    @Caption(value="Numero Quadras")
    private Long numeroQuadras;
    @Caption(value="\u00c1rea Loteada")
    private BigDecimal areaLoteada = BigDecimal.ZERO;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="idato", referencedColumnName="idato")})
    private Ato ato;
    @Caption(value="\u00c1rea Sistema Vi\u00e1rio")
    private BigDecimal areaSistemaViario = BigDecimal.ZERO;
    @Length(max=60)
    @Caption(value="Gleba")
    private @Length(max=60) String gleba;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Irregular")
    private Boolean irregular = Boolean.FALSE;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    @Length(max=250)
    @Caption(value="Usu\u00e1rio")
    private @Length(max=250) String usuario;

    public Loteamento withPk(Long loteamento) {
        this.setId(loteamento);
        return this;
    }

    @DiffRevisionIgnore
    public boolean isNew() {
        return Objects.nonNull(this.getId()) && Objects.nonNull(this.getSetor()) && Objects.nonNull(this.getLoteamento());
    }

    public Loteamento mergeElogeo(Loteamento loteamentoToMerge) {
        Assert.isTrue((boolean)Optional.ofNullable(loteamentoToMerge.getLoteamento()).filter(loteamentoMerge -> loteamentoMerge.equals(this.getLoteamento())).isPresent(), (String)"Para fazer o merge, os cadastros devem ter o mesmo c\u00f3digo");
        this.setDistrito(loteamentoToMerge.getDistrito());
        this.setSetor(loteamentoToMerge.getSetor());
        this.setDescricao(loteamentoToMerge.getDescricao());
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Loteamento)) {
            return false;
        }
        Loteamento other = (Loteamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Loteamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Loteamento(id=" + this.getId() + ")";
    }

    @Generated
    public Loteamento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Distrito getDistrito() {
        return this.distrito;
    }

    @Generated
    public Setor getSetor() {
        return this.setor;
    }

    @Generated
    public Long getLoteamento() {
        return this.loteamento;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Pessoa getLoteador() {
        return this.loteador;
    }

    @Generated
    public Pessoa getProprietario() {
        return this.proprietario;
    }

    @Generated
    public Bairro getBairro() {
        return this.bairro;
    }

    @Generated
    public String getApelido() {
        return this.apelido;
    }

    @Generated
    public Long getNumeroLotes() {
        return this.numeroLotes;
    }

    @Generated
    public Long getNumeroQuadras() {
        return this.numeroQuadras;
    }

    @Generated
    public BigDecimal getAreaLoteada() {
        return this.areaLoteada;
    }

    @Generated
    public Ato getAto() {
        return this.ato;
    }

    @Generated
    public BigDecimal getAreaSistemaViario() {
        return this.areaSistemaViario;
    }

    @Generated
    public String getGleba() {
        return this.gleba;
    }

    @Generated
    public Boolean getIrregular() {
        return this.irregular;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDistrito(Distrito distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    @Generated
    public void setLoteamento(Long loteamento) {
        this.loteamento = loteamento;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setLoteador(Pessoa loteador) {
        this.loteador = loteador;
    }

    @Generated
    public void setProprietario(Pessoa proprietario) {
        this.proprietario = proprietario;
    }

    @Generated
    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    @Generated
    public void setNumeroLotes(Long numeroLotes) {
        this.numeroLotes = numeroLotes;
    }

    @Generated
    public void setNumeroQuadras(Long numeroQuadras) {
        this.numeroQuadras = numeroQuadras;
    }

    @Generated
    public void setAreaLoteada(BigDecimal areaLoteada) {
        this.areaLoteada = areaLoteada;
    }

    @Generated
    public void setAto(Ato ato) {
        this.ato = ato;
    }

    @Generated
    public void setAreaSistemaViario(BigDecimal areaSistemaViario) {
        this.areaSistemaViario = areaSistemaViario;
    }

    @Generated
    public void setGleba(String gleba) {
        this.gleba = gleba;
    }

    @Generated
    public void setIrregular(Boolean irregular) {
        this.irregular = irregular;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }
}

