/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config.outbox;

import br.com.elotech.multitenant.config.MultiTenantClientConfiguration;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.outbox.EnableOutboxProducerDataIntegration;
import br.com.elotech.outbox.publisher.PublishKey;
import br.com.elotech.outbox.publisher.RecordEntityClass;
import br.com.elotech.outbox.publisher.RecordSaver;
import br.com.elotech.tributos.domain.OutboxEntity;
import br.com.elotech.tributos.repository.OutboxRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableOutboxProducerDataIntegration
@AutoConfigureAfter(value={MultiTenantClientConfiguration.class})
public class OutboxProducerConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutboxProducerConfiguration.class);

    @Bean
    public RecordSaver recordSaver(OutboxRepository outboxRepository) {
        return outboxRecord -> outboxRepository.save((Object)((OutboxEntity)outboxRecord));
    }

    @Bean
    public RecordEntityClass recordEntityClass() {
        return OutboxEntity::new;
    }

    @Bean
    public PublishKey publishKey() {
        return () -> TenantContextHolder.getTenantId().orElse("");
    }
}

