/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaomonetariada;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoCreditoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoCreditoDAId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDAId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoDAId;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaCreditoDAConsultaDTO;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoDARepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AtualizacaoMonetariaCreditoDABatchProcessor
implements ItemProcessor<AtualizacaoMonetariaCreditoDAConsultaDTO, TipoAtualizacaoMonetariaCreditoDA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtualizacaoMonetariaCreditoDABatchProcessor.class);
    private static String PREFIXO = "SIM-AM - Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private AtomicLong ultimoNrAtualizacao = new AtomicLong(0L);
    private Long nrAnoAtualizacao;
    private StepExecution stepExecution;
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info(PREFIXO + "Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info(PREFIXO + "Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoAtualizacao = dataInicial.getYear();
        LOGGER.info(PREFIXO + "Atualizando \u00faltimo NrAtualizacao");
        this.ultimoNrAtualizacao.set(this.atualizacaoMonetariaCreditoDARepository.findNextNrAtualizacaoByExercicio(Long.valueOf(dataInicial.getYear())));
        LOGGER.info(PREFIXO + "load da carga existente");
        this.atualizacaoMonetariaCreditoDARepository.getCargaExistente(dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizamoneCredDA()));
    }

    public TipoAtualizacaoMonetariaCreditoDA process(AtualizacaoMonetariaCreditoDAConsultaDTO item) {
        String chave = String.format("%d-%d-%d-%s-%d", item.getIdTipoAtualizacaoCredito(), item.getNrdivida(), item.getNranodivida(), item.getDtAtualizacao().toString(), item.getCdControleLeiAto());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEATUALIZAMONECREDDA");
            AtualizacaoMonetariaCreditoDA atualizacao = new AtualizacaoMonetariaCreditoDA();
            atualizacao.setId(nextId);
            atualizacao.setDtAtualizacao(item.getDtAtualizacao());
            atualizacao.setIdTipoAtualizacaoCredito(item.getIdTipoAtualizacaoCredito());
            atualizacao.setNrAtualizacao(Long.valueOf(this.ultimoNrAtualizacao.getAndIncrement()));
            atualizacao.setNrAnoAtualizacao(this.nrAnoAtualizacao);
            atualizacao.setNrDivida(item.getNrdivida());
            atualizacao.setNrAnoDivida(item.getNranodivida());
            atualizacao.setCdControleLeiAto(item.getCdControleLeiAto());
            atualizacao.setVlAtualizacao(BigDecimal.ZERO);
            atualizacao.setNrDivida(item.getNrdivida());
            atualizacao.setNrAnoDivida(item.getNranodivida());
            atualizacao.setCdControleLeiAto(item.getCdControleLeiAto());
            LOGGER.info(PREFIXO + "Gerando novo registro -> {} ({}/{})", new Object[]{nextId, atualizacao.getNrAtualizacao(), atualizacao.getNrAnoAtualizacao()});
            this.atualizacaoMonetariaCreditoDARepository.saveAndFlush((Object)atualizacao);
            return nextId;
        });
        AtualizacaoMonetariaCreditoDA atualizacaoMonetariaDA = (AtualizacaoMonetariaCreditoDA)this.entityManager.getReference(AtualizacaoMonetariaCreditoDA.class, (Object)finalId);
        atualizacaoMonetariaDA.setVlAtualizacao(atualizacaoMonetariaDA.getVlAtualizacao().add(item.getVlAtualizacao()));
        if (item.hasIdCreditoContribuinteItem()) {
            AtualizacaoMonetariaCreditoCreditoDAId id = new AtualizacaoMonetariaCreditoCreditoDAId();
            id.setAtualizacaoMonetariaCreditoDA((AtualizacaoMonetariaCreditoDA)this.entityManager.getReference(AtualizacaoMonetariaCreditoDA.class, (Object)finalId));
            id.setIdCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)item.getIdCreditoContribuinteItem()));
            id.setIdDebitoParcelaReceita(item.getIddebitoparcelareceita());
            return new AtualizacaoMonetariaCreditoCreditoDA(id, item.getVlAtualizacao());
        }
        if (item.hasIdPagamentoBloqueto()) {
            AtualizacaoMonetariaPagamentoDAId id = new AtualizacaoMonetariaPagamentoDAId();
            id.setAtualizacaoMonetariaCreditoDA((AtualizacaoMonetariaCreditoDA)this.entityManager.getReference(AtualizacaoMonetariaCreditoDA.class, (Object)finalId));
            id.setIdDebitoParcelaReceita(item.getIddebitoparcelareceita());
            id.setIdPagamentoBloqueto(item.getIdpagamentobloqueto());
            return new AtualizacaoMonetariaPagamentoDA(id, item.getVlAtualizacao());
        }
        if (item.hasIdParcelamento()) {
            AtualizacaoMonetariaCreditoParcelamentoDAId id = new AtualizacaoMonetariaCreditoParcelamentoDAId();
            id.setIdParcelamento(item.getIdParcelamento());
            id.setAtualizacaoMonetariaCreditoDA(finalId);
            id.setIdDebitoParcelaReceita(item.getIddebitoparcelareceita());
            return new AtualizacaoMonetariaCreditoParcelamentoDA(id, item.getVlAtualizacao());
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error(PREFIXO + "Erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
        throw e;
    }

    @Generated
    public AtualizacaoMonetariaCreditoDABatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.atualizacaoMonetariaCreditoDARepository = atualizacaoMonetariaCreditoDARepository;
    }
}

