SELECT DISTINCT
                :idPessoa as idPessoa,
                icd.nrdivida,
                icd.nranodivida,
                icd.idtipooperacaocredito,
                tlc.nrcredito,
                tlc.nrAnoCredito,
                case when (icd.idtipooperacaocredito = 3) then null else icd.idtiponaturezacredito end as idtiponaturezacredito,
                case when (icd.idtipooperacaocredito = 3) then null else icd.idtipocredito end as idtipocredito,
                case when (icd.idtipooperacaocredito = 3) then null else EXTRACT(YEAR FROM tdp.datalancamento)  end AS nrAnoBase,
                cg.idtce                               AS cdControleLeiAto,
                icd.dtinscricao,
                icd.vlinscricao,
                EXTRACT(YEAR FROM tdp.datadividaativa) AS nrAnoInscricao
FROM tceInscCreditoDA icd
         INNER JOIN tceDebitoInscCreditoDA dic
                    ON dic.idtceinsccreditoda = icd.idtceinsccreditoda
         LEFT JOIN tcedebitolanccredito tdl
                   ON tdl.iddebitoparcelareceita = dic.iddebitoparcelareceitaOrigem
         LEFT JOIN tcelanccredito tlc
                   ON tlc.idtcelanccredito = tdl.idtcelanccredito
         INNER JOIN tribdebitoparcelareceita tdpr
                    ON tdpr.iddebitoparcelareceita = dic.iddebitoparcelareceitaOrigem
         INNER JOIN tribdebitoparcela tdp
                    ON tdp.entidade = tdpr.entidade
                        AND tdp.exercicio = tdpr.exercicio
                        AND tdp.tipocadastro = tdpr.tipocadastro
                        AND tdp.cadastrogeral = tdpr.cadastrogeral
                        AND tdp.guiarecolhimento = tdpr.guiarecolhimento
                        AND tdp.subdivida = tdpr.subdivida
                        AND tdp.parcela = tdpr.parcela
         LEFT JOIN triblivroparcelareceita tlvp
                    ON tlvp.iddebitoparcelareceita = dic.iddebitoparcelareceitaOrigem
         LEFT JOIN triblivroregistro tvr
                    ON tvr.entidade = tlvp.entidade
                        AND tvr.exercicio = tlvp.exercicio
                        AND tvr.livro = tlvp.livro
                        and tvr.sequencia = tlvp.sequencia
         LEFT JOIN cgato cg
                   ON cg.entidade = tvr.entidade
                       AND cg.idato = tvr.fundamentolegal
WHERE tdpr.entidade = :entidade
    and icd.dtinscricao between :dataInicial and :dataFinal
ORDER BY icd.nrdivida, icd.nranodivida
