select :idPessoa as idPessoa,
       filtro.nrAnoEstorno,
       filtro.nrAtualizacao,
       filtro.nrAnoAtualizacao,
       filtro.cdControleLeiAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo
from
(
   select extract(year from tep.data) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tep.data) as nrMes,
          extract(year  from tep.data) as nrAno,
          ca.idato as cdControleLeiAto,
          tep.data as dtEstorno,
          tpd.valorjuros as vlEstorno,
          substr(tmd.descricao || '. ' || tep.motivoestorno, 0, 250) as dsMotivo
   FROM tribestornopagamento             tep
        join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
        join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
        join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
        join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
   left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
   left join cgato                       ca   on ca.entidade = tep.entidade and ca.idato = tmd.idato
   WHERE tep.entidade = :entidade
     and tep.data BETWEEN :dataInicial AND :dataFinal
     and tep.geracreditocontribuinte = 'N'
     and tpd.estorno = 'S'
     and tpd.valorjuros > 0
     and tamc.idtipoatualizacaocredito = 1
   union all
   select extract(year from tep.data) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tep.data) as nrMes,
          extract(year  from tep.data) as nrAno,
          ca.idato as cdControleLeiAto,
          tep.data as dtEstorno,
          tpd.valormulta as vlEstorno,
          substr(tmd.descricao || '. ' || tep.motivoestorno, 0, 250) as dsMotivo
   FROM tribestornopagamento             tep
        join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
        join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
        join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
        join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
   left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
   left join cgato                       ca   on ca.entidade = tep.entidade and ca.idato = tmd.idato
   WHERE tep.entidade = :entidade
     and tep.data BETWEEN :dataInicial AND :dataFinal
     and tep.geracreditocontribuinte = 'N'
     and tpd.estorno = 'S'
     and tpd.valormulta > 0
     and tamc.idtipoatualizacaocredito = 2
   union all
   select extract(year from tep.data) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tep.data) as nrMes,
          extract(year  from tep.data) as nrAno,
          ca.idato as cdControleLeiAto,
          tep.data as dtEstorno,
          tpd.valorcorrecao as vlEstorno,
          substr(tmd.descricao || '. ' || tep.motivoestorno, 0, 250) as dsMotivo
   FROM tribestornopagamento             tep
        join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
        join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
        join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
        join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
   left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
   left join cgato                       ca   on ca.entidade = tep.entidade and ca.idato = tmd.idato
   WHERE tep.entidade = :entidade
     and tep.data BETWEEN :dataInicial AND :dataFinal
     and tep.geracreditocontribuinte = 'N'
     and tpd.estorno = 'S'
     and tpd.valorcorrecao > 0
     and tamc.idtipoatualizacaocredito = 3
   union all
   SELECT extract(year from tcc.dataestorno) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tcc.dataestorno) as nrMes,
          extract(year  from tcc.dataestorno) as nrAno,
          ca.idato as cdControleLeiAto,
          tcc.dataestorno as dtEstorno,
          tcci.valorjuros as vlEstorno,
          substr(tmd.descricao  || '. ' || tcc.observacaoestorno, 0, 250) as dsMotivo
   FROM tribcreditocontribuinte           tcc
        join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
        join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
   left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
   left join cgato                        ca    on ca.entidade = tcc.entidade and ca.idato = tmd.idato
   WHERE tcc.entidade = :entidade
     and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
     and tcci.valorjuros > 0
     and tamc.idtipoatualizacaocredito = 1
   union all
   SELECT extract(year from tcc.dataestorno) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tcc.dataestorno) as nrMes,
          extract(year  from tcc.dataestorno) as nrAno,
          ca.idato as cdControleLeiAto,
          tcc.dataestorno as dtEstorno,
          tcci.valormulta as vlEstorno,
          substr(tmd.descricao  || '. ' || tcc.observacaoestorno, 0, 250) as dsMotivo
   FROM tribcreditocontribuinte           tcc
        join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
        join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
   left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
   left join cgato                        ca    on ca.entidade = tcc.entidade and ca.idato = tmd.idato
   WHERE tcc.entidade = :entidade
     and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
     and tcci.valormulta > 0
     and tamc.idtipoatualizacaocredito = 2
   union all
   SELECT extract(year from tcc.dataestorno) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tcc.dataestorno) as nrMes,
          extract(year  from tcc.dataestorno) as nrAno,
          ca.idato as cdControleLeiAto,
          tcc.dataestorno as dtEstorno,
          tcci.valorcorrecao as vlEstorno,
          substr(tmd.descricao  || '. ' || tcc.observacaoestorno, 0, 250) as dsMotivo
   FROM tribcreditocontribuinte           tcc
        join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
        join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
   left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
   left join cgato                        ca    on ca.entidade = tcc.entidade and ca.idato = tmd.idato
   WHERE tcc.entidade = :entidade
     and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
     and tcci.valorcorrecao > 0
     and tamc.idtipoatualizacaocredito = 3
   union all
   select extract(year from tep.dataestorno) as nrAnoEstorno,
          tamc.nrAtualizacao,
          tamc.nrAnoAtualizacao,
          extract(month from tep.dataestorno) as nrMes,
          extract(year  from tep.dataestorno) as nrAno,
          ca.idato as cdControleLeiAto,
          tep.dataestorno as dtEstorno,
          x.valor as vlEstorno,
          substr(tmd.descricao || '. ' || tep.motivo, 0, 250) as dsMotivo
   from tribestornoparcelamento            tep
   join tribestparcelamparcrecdestino tepd  on tepd.idestornoparcelamento = tep.idestornoparcelamento
   join tribParcelamentoParcRecOrigem tppro on tppro.idparcelamento = tep.idparcelamento and tppro.iddebitoparcelareceita = tepd.iddebitoparcelareceita
   join tribdebitoparcelareceita tdpr_origem on tppro.iddebitoparcelareceita = tdpr_origem.iddebitoparcelareceita
   join tceAtualizaMoneParcDA         tamp  on tamp.idparcelamento = tppro.idparcelamento and tamp.iddebitoparcelareceita = tppro.iddebitoparcelareceita
   join tceAtualizaMoneCredDa         tamc  on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
   join tribparcelamento              tpar  on tpar.idparcelamento = tep.idparcelamento
   left join tribparamparcelamento    tpp   on tpp.idparametroparcelamento = tpar.idparametroparcelamento
   left join tribmotivodesconto       tmd   on tmd.motivodesconto = tpp.motivoestorno
   left join cgato                    ca    on ca.entidade = tmd.entidade and ca.idato = tmd.idato
   join (select case when (tr.classificacao = 'J') then 1
                when (tr.classificacao = 'M') then 2 else 3 end as idTipoAtualizacaoCredito,
              tp.dataparcelamento as dtAtualizacao,
              a.receita as receitaPrincipal,
              tr.receita,
              tr.classificacao,
              tp.idParcelamento,
              sum(tdpr.valor) as valor
       from tribparcelamento              tp
       join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento
       join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo
       join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio
                                               and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral
                                               and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida
       join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio
                                               and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral
                                               and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida
                                               and tdpr.parcela = tdp.parcela
       join (select tr.receita, tr.classificacao, tp.idParcelamento
             from tribparcelamento              tp
             join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento
             join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo
             join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio and tdp.tipocadastro = td.tipocadastro
                                                     and tdp.cadastrogeral = td.cadastrogeral and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida
             join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio and tdpr.tipocadastro = tdp.tipocadastro
                                                     and tdpr.cadastrogeral = tdp.cadastrogeral and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida
                                                     and tdpr.parcela = tdp.parcela
             join tribreceita                   tr    on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
             where tr.classificacao = 'P'
               and tdp.situacaolegal in (1,2)
             group by tr.receita, tr.classificacao, tp.idparcelamento) a
        on a.idparcelamento = tp.idparcelamento
       join tribguiarecolhimentoreceita   tgrr  on tgrr.entidade = tdpr.entidade and tgrr.exercicio = tdpr.exercicio
                                               and tgrr.guiarecolhimento = tdpr.guiarecolhimento and tgrr.receita = a.receita
       join tribguiareceitaespelho        tgre  on tgre.entidade = tgrr.entidade and tgre.exercicio = tgrr.exercicio
                                               and tgre.guiarecolhimento = tgrr.guiarecolhimento
                                               and (tgre.jurosdestino = tdpr.receita or tgre.multadestino = tdpr.receita or tgre.correcaodestino = tdpr.receita)
       join tribreceita                   tr    on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
       and a.receita = tgre.receita
       where tr.classificacao in ('J','M','C')
       group by tr.receita, tr.classificacao,  tp.idparcelamento, a.receita) x
    on x.idparcelamento = tep.idparcelamento
   and x.idTipoAtualizacaoCredito = tamc.idTipoAtualizacaoCredito
   and x.receitaPrincipal = tdpr_origem.receita
   where tpar.entidade = :entidade and tep.dataestorno BETWEEN :dataInicial AND :dataFinal
   and tamc.idtipoatualizacaocredito in (1,2,3)
) filtro
order by filtro.nrAnoAtualizacao, filtro.nrAtualizacao