
SELECT :idPessoa as idPessoa,
       filtro.nrAnoEstorno,
       filtro.nrArrecadacao,
       filtro.nrAnoArrecadacao,
       filtro.nrMes,
       filtro.nrAno,
       filtro.vlEstorno
FROM
  (SELECT extract(YEAR
                  FROM tep.data) AS nrAnoEstorno,
          atc.nrarrecadacao,
          atc.nranoarrecadacao,
          extract(MONTH
                  FROM tep.data) AS nrMes,
          extract(YEAR
                  FROM tep.data) AS nrAno,
          tpd.valorpago AS vlEstorno
   FROM tribestornopagamento tep
   JOIN tribestornopagamentoitem tepi ON tepi.entidade = tep.entidade
   AND tepi.exercicio = tep.exercicio
   AND tepi.estorno = tep.estorno
   JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tepi.idpagamentobloqueto
   AND tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
   LEFT JOIN tceArrTipoCreditoPagamento atcp ON atcp.idpagamentobloqueto = tepi.idpagamentobloqueto
   AND atcp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
   LEFT JOIN tceArrecadacaoTipoCredito atc ON atc.idtcearrtipocredito = atcp.idtcearrtipocredito
   WHERE tep.entidade = :entidade
     AND tep.data BETWEEN :dataInicial AND :dataFinal
     AND tep.geracreditocontribuinte = 'N'
     AND tpd.estorno = 'S'
   UNION ALL SELECT extract(YEAR
                            FROM tcc.dataestorno) AS nrAnoEstorno,
                    atc.nrarrecadacao,
                    atc.nranoarrecadacao,
                    extract(MONTH
                            FROM tcc.dataestorno) AS nrMes,
                    extract(YEAR
                            FROM tcc.dataestorno) AS nrAno,
                    tcc.valorestornado AS vlEstorno
   FROM tribcreditocontribuinte tcc
   JOIN tribCreditoContribuinteItem tcci ON tcci.entidade = tcc.entidade
   AND tcci.exercicio = tcc.exercicio
   AND tcci.creditocontribuinte = tcc.creditocontribuinte
   LEFT JOIN tcearrtipocreditocredito atcc ON atcc.idcreditoContribuinteItem = tcci.idCreditoContribuinteItem
   AND atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   LEFT JOIN tceArrecadacaoTipoCredito atc ON atc.idtcearrtipocredito = atcc.idtcearrtipocredito
   WHERE tcc.entidade = :entidade
     AND tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
     AND tcc.valorestornado > 0 ) filtro
ORDER BY filtro.nranoarrecadacao,
         filtro.nrarrecadacao