select 08                                                 as codigoArquivo,
       'Estorno da Inscrição de Créditos em Dívida Ativa' as arquivo,
       'CREDITO'                                          as tipoArquivo,
       arquivo.valor                           as valorArquivo,
       integracao.valor                        as valorIntegracao
from (
         select sum(filtro.valor) as valor
         from (select coalesce(sum(tlpr.valor), 0) as valor
               from triblivroestornoparcelareceita tlepr

                        join tribdebitoparcelareceita tdpr
                             on tdpr.iddebitoparcelareceita = tlepr.iddebitoparcelareceita

                        join triblivroparcelareceita tlpr
                             on tlpr.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                        join triblivroestorno te on te.idlivroestorno = tlepr.idlivroestorno
                        join tribreceita tr
                             on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio
                        join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               where trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)

                 and te.dataestorno between :dataInicial and :dataFinal
                 and tlpr.estornado = 'S'
              ) filtro
     ) as arquivo
         cross join (select 0 as valor
                     from dual
) as integracao