select 14                                                as codigoArquivo,
       'Arrecadação por Tipo de Crédito em Dívida Ativa' as arquivo,
       'CREDITO'                                         as tipoArquivo,
       arquivo.valor                                     as valorArquivo,
       integracao.valor                                  as valorIntegracao
from (
         select sum(coalesce(atc.vlArrecadacao, 0)) as valor
         from tceArrecadacaoTipoCredito atc

                  left join tceArrTipoCreditoPagamento atcp on atcp.idtcearrtipocredito =
                                                               atc.idtcearrtipocredito

                  left join tribpagamentodebito tpd on tpd.iddebitoparcelareceita =
                                                       atcp.iddebitoparcelareceita and tpd.
                                                                                           idpagamentobloqueto =
                                                                                       atcp.idpagamentobloqueto

                  left join tribpagamentobloqueto tpb
                            on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
                  left join tribpagamento tpag on tpag.entidade = tpb.entidade and
                                                  tpag.exerciciopagamento = tpb.exerciciopagamento and
                                                  tpag.pagamento = tpb.pagamento
                  left join tceArrTipoCreditoCredito atcc
                            on atcc.idtcearrtipocredito = atc.idtcearrtipocredito
                  left join tribCreditoContribuinteItem tcci
                            on tcci.idcreditocontribuinteitem = atcc.idcreditocontribuinteitem and
                               tcci.iddebitoparcelareceita = atcc.iddebitoparcelareceita
                  left join tribcreditocontribuinte tcc
                            on tcc.entidade = tcci.entidade and tcc.exercicio = tcci.exercicio and
                               tcc.creditocontribuinte = tcci.creditocontribuinte

         where coalesce(tpag.datacredito, tcc.datacredito) BETWEEN :dataInicial AND :dataFinal
           and coalesce(tpag.entidade, tcc.entidade) = :entidade
           and idTipoOrigemReceita = 2) arquivo
         cross join (select sum(liic.valortributo - liic.valordeducao) as valor
                     from loteintegracaocontabil lic
                              left join loteitemintegracaocontabil liic
                                        on lic.id = liic.idlote
                              left join tribreceita tr on liic.idtributo = tr.id
                              left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                     where lic.datalote between :dataInicial and :dataFinal
                       and liic.situacaolegal = 1
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                       and lic.tipolote = 'PAGAMENTO') integracao