select 13                                             as codigoArquivo,

       'Arrecadação por Tipo de Crédito no Exercício' as arquivo,
       'CREDITO'                                      as tipoArquivo,
       arquivo.valor                                  as valorArquivo,
       integracao.valor                               as valorIntegracao
from (select sum(atc.vlArrecadacao) as valor
      from tceArrecadacaoTipoCredito atc

               left join tceArrTipoCreditoPagamento atcp on atcp
                                                                .idtcearrtipocredito =
                                                            atc.idtcearrtipocredito

               left join tribpagamentodebito tpd on tpd.
                                                        iddebitoparcelareceita =
                                                    atcp.iddebitoparcelareceita and
                                                    tpd.idpagamentobloqueto = atcp.idpagamentobloqueto

               left join tribpagamentobloqueto tpb
                         on tpb.
                                idpagamentobloqueto = tpd.idpagamentobloqueto
               left join tribpagamento tpag on tpag
                                                   .entidade = tpb.entidade and
                                               tpag.exerciciopagamento = tpb.exerciciopagamento and
                                               tpag.pagamento = tpb.pagamento

      where coalesce(tpag.datacredito) BETWEEN :dataInicial AND :dataFinal
        and coalesce(tpag.entidade) = :entidade
        and idTipoOrigemReceita = 1) arquivo
         cross join (select sum(liic.valortributo - liic.valordeducao) as valor
                     from loteintegracaocontabil lic
                              left join loteitemintegracaocontabil liic
                                        on lic.id = liic.idlote
                              left join tribreceita tr on liic.idtributo = tr.id
                              left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                     where lic.datalote between :dataInicial and :dataFinal
                       and liic.situacaolegal = 0
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                       and lic.tipolote = 'PAGAMENTO') integracao