/* Pagamentos */         
select distinct 
       tam.idTceAtualizamoneCredDA,
       tam.idtipoatualizacaocredito,
       tam.dtatualizacao,
       tam.nranoatualizacao,
       tic.nrdivida,
       tic.nranodivida,
       ca.idtce as cdControleLeiAto,
       case
         when tam.idtipoatualizacaocredito = 1 then tpd.valorjuros
         when tam.idtipoatualizacaocredito = 2 then tpd.valormulta
         when tam.idtipoatualizacaocredito = 3 then tpd.valorcorrecao
         else 0
       end as valor  
from tceAtualizaMoneCredDA tam 
join tceAtualizaMonePagamentoDA tamp on tamp.idTceAtualizamoneCredDA = tam.idTceAtualizamoneCredDA
join tribpagamentobloqueto      tpb  on tpb.idpagamentobloqueto = tamp.idpagamentobloqueto
join tribpagamentodebito        tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.iddebitoparcelareceita = tamp.iddebitoparcelareceita
join tribdebitoparcelareceita   tdpr on tdpr.iddebitoparcelareceita = tamp.iddebitoparcelareceita
left join tcedebitoinsccreditoDA      tdic on tdic.iddebitoparcelareceitadestino = tdpr.iddebitoparcelareceita 
left join tceinsccreditoDA            tic  on tic.idtceinsccreditoda = tdic.idtceinsccreditoda
join tribguiarecolhimento       tgr  on tdpr.entidade = tgr.entidade and tdpr.exercicio = tgr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
left join cgato                 ca   on ca.entidade = tgr.entidade and ca.idato = tgr.fundamentolegal
where tam.dtatualizacao between :dataInicial and :dataFinal
union all
/* Créditos */
select distinct
       tam.idTceAtualizamoneCredDA,
       tam.idtipoatualizacaocredito,
       tam.dtatualizacao,
       tam.nranoatualizacao,
       tic.nrdivida,
       tic.nranodivida,
       ca.idtce as cdControleLeiAto,
       case
         when tam.idtipoatualizacaocredito = 1 then tcci.valorjuros
         when tam.idtipoatualizacaocredito = 2 then tcci.valormulta
         when tam.idtipoatualizacaocredito = 3 then tcci.valorcorrecao
         else 0
       end as valor  
from tceAtualizaMoneCredDA tam 
join tceAtualizaMoneCreditoDA    tamc on tamc.idTceAtualizamoneCredDA = tamc.idTceAtualizamoneCredDA
join tribcreditocontribuinteitem tcci on tcci.idcreditocontribuinteitem = tamc.idcreditocontribuinteitem and tcci.iddebitoparcelareceita = tamc.iddebitoparcelareceita
join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tamc.iddebitoparcelareceita
left join tcedebitoinsccreditoDA tdic on tdic.iddebitoparcelareceitadestino = tdpr.iddebitoparcelareceita 
left join tceinsccreditoDA       tic  on tic.idtceinsccreditoda = tdic.idtceinsccreditoda
join tribguiarecolhimento        tgr  on tdpr.entidade = tgr.entidade and tdpr.exercicio = tgr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
left join cgato                  ca   on ca.entidade = tgr.entidade and ca.idato = tgr.fundamentolegal
where tam.dtatualizacao between :dataInicial and :dataFinal
union all
/* Parcelamentos */
select distinct
       tam.idTceAtualizamoneCredDA,
       tam.idtipoatualizacaocredito,
       tam.dtatualizacao,
       tam.nranoatualizacao,
       tic.nrdivida,
       tic.nranodivida,
       x.cdControleLeiAto,
       x.valor
from tceAtualizaMoneCredDA tam 
join tceAtualizaMoneParcDA          tampar      on tampar.idTceAtualizamoneCredDA = tam.idTceAtualizamoneCredDA
join tribParcelamentoParcRecOrigem  tppro       on tppro.idparcelamento = tampar.idparcelamento and tppro.iddebitoparcelareceita = tampar.iddebitoparcelareceita
join tribdebitoparcelareceita       tdpr_origem on tppro.iddebitoparcelareceita = tdpr_origem.iddebitoparcelareceita
left join tcedebitoinsccreditoDA    tdic        on tdic.iddebitoparcelareceitadestino = tdpr_origem.iddebitoparcelareceita 
left join tceinsccreditoDA          tic         on tic.idtceinsccreditoda = tdic.idtceinsccreditoda
join tribparcelamento               tpar        on tpar.idparcelamento = tampar.idparcelamento
left join tribparamparcelamento     tpp         on tpp.idparametroparcelamento = tpar.idparametroparcelamento
join (select case when (tr.classificacao = 'J') then 1
             when (tr.classificacao = 'M') then 2 else 3 end as idTipoAtualizacaoCredito, 
           tp.dataparcelamento as dtAtualizacao, 
           a.receita as receitaPrincipal, 
           tr.receita, 
           tr.classificacao, 
           tp.idParcelamento,
           ca.idtce as cdControleLeiAto,
           sum(tdpr.valor) as valor 
    from tribparcelamento              tp 
    join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento 
    join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
    join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio 
                                            and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral 
                                            and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
    join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio 
                                            and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral 
                                            and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                            and tdpr.parcela = tdp.parcela 
    join (select tr.receita, tr.classificacao, tp.idParcelamento 
          from tribparcelamento              tp 
          join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento 
          join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
          join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio and tdp.tipocadastro = td.tipocadastro 
                                                  and tdp.cadastrogeral = td.cadastrogeral and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
          join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio and tdpr.tipocadastro = tdp.tipocadastro 
                                                  and tdpr.cadastrogeral = tdp.cadastrogeral and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                                  and tdpr.parcela = tdp.parcela 
          join tribreceita                   tr    on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita 
          where tr.classificacao = 'P'
            and tdp.situacaolegal in (1,2) 
          group by tr.receita, tr.classificacao, tp.idparcelamento) a
     on a.idparcelamento = tp.idparcelamento
    join tribguiarecolhimento          tgr   on tdpr.entidade = tgr.entidade and tdpr.exercicio = tgr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
    left join cgato                    ca    on ca.entidade = tgr.entidade and ca.idato = tgr.fundamentolegal    
    join tribguiarecolhimentoreceita   tgrr  on tgrr.entidade = tdpr.entidade and tgrr.exercicio = tdpr.exercicio 
                                            and tgrr.guiarecolhimento = tdpr.guiarecolhimento and tgrr.receita = a.receita
    join tribguiareceitaespelho        tgre  on tgre.entidade = tgrr.entidade and tgre.exercicio = tgrr.exercicio 
                                            and tgre.guiarecolhimento = tgrr.guiarecolhimento 
                                            and (tgre.jurosdestino = tdpr.receita or tgre.multadestino = tdpr.receita or tgre.correcaodestino = tdpr.receita) 
    join tribreceita                   tr    on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita 
    and a.receita = tgre.receita
    where tr.classificacao in ('J','M','C') 
    group by tr.receita, tr.classificacao,  tp.idparcelamento, a.receita, ca.idtce) x
 on x.idparcelamento = tampar.idparcelamento
and x.idTipoAtualizacaoCredito = tam.idTipoAtualizacaoCredito
and x.receitaPrincipal = tdpr_origem.receita
where tam.dtatualizacao between :dataInicial and :dataFinal
and tam.idtipoatualizacaocredito in (1,2,3)
order by 1,2