select filtro.idTipoAtualizacaoCredito, 
       filtro.dtAtualizacao, 
       filtro.nrcredito, 
       filtro.nranocredito, 
       filtro.idpagamentobloqueto, 
       filtro.iddebitoparcelareceita, 
       filtro.idCreditoContribuinteItem, 
       filtro.vlAtualizacao, 
       ca.idTce as cdControleLeiAto
from ( 
  select 1 as idTipoAtualizacaoCredito, 
         tpd.valorjuros as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         tp.datapagamento as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribpagamento tp 
  join tribpagamentobloqueto tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento 
  join tribpagamentodebito   tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0 and tpd.situacaolegal = 0 and tpd.valorpago > 0 
  join tcedebitolanccredito  tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
  join tcelanccredito        tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists ( 
       select 1 
       from tceAtualizaMonePagamento tamp 
       where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto 
         and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
    ) 
  union all 
  select 2 as idTipoAtualizacaoCredito, 
         tpd.valormulta as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         tp.datapagamento as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribpagamento tp 
  join tribpagamentobloqueto tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento 
  join tribpagamentodebito   tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0 and tpd.situacaolegal = 0 and tpd.valorpago > 0 
  join tcedebitolanccredito  tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
  join tcelanccredito        tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists ( 
       select 1 
       from tceAtualizaMonePagamento tamp 
       where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto 
         and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
    ) 
  union all 
  select 3 as idTipoAtualizacaoCredito, 
         tpd.valorcorrecao as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         tp.datapagamento as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribpagamento tp 
  join tribpagamentobloqueto tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento 
  join tribpagamentodebito   tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0 and tpd.situacaolegal = 0 and tpd.valorpago > 0 
  join tcedebitolanccredito  tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
  join tcelanccredito        tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists ( 
       select 1 
       from tceAtualizaMonePagamento tamp 
       where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto 
         and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
    ) 
  union all 
  select 1 as idTipoAtualizacaoCredito, 
         tcci.valorjuros as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         tcc.datacredito as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  join tcedebitolanccredito        tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tcelanccredito              tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tcc.entidade = :entidade 
    and tcc.datacredito BETWEEN :dataInicial and :dataFinal 
    and tcci.valorjuros > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal = 0 
    and not exists ( 
       select 1 
       from tceatualizamonecredito tamc 
       where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem 
         and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
    ) 
  union all 
  select 2 as idTipoAtualizacaoCredito, 
         tcci.valormulta as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         tcc.datacredito as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  join tcedebitolanccredito        tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tcelanccredito              tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tcc.entidade = :entidade 
    and tcc.datacredito BETWEEN :dataInicial and :dataFinal 
    and tcci.valormulta > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal = 0 
    and not exists ( 
       select 1 
       from tceatualizamonecredito tamc 
       where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem 
         and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
    ) 
  union all 
  select 3 as idTipoAtualizacaoCredito, 
         tcci.valorcorrecao as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         tcc.datacredito as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  join tcedebitolanccredito        tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tcelanccredito              tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tcc.entidade = :entidade 
    and tcc.datacredito BETWEEN :dataInicial and :dataFinal 
    and tcci.valorcorrecao > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal = 0 
    and not exists ( 
       select 1 
       from tceatualizamonecredito tamc 
       where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem 
         and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
    ) 
) filtro 
 inner join tribDebitoParcelaReceita tdpr_f on tdpr_f.iddebitoparcelareceita = filtro.iddebitoparcelareceita 
  left join tribguiarecolhimento     tg on tg.entidade =  :entidade
                                       and tg.exercicio  =  :exercicio
                                       and tg.guiarecolhimento = tdpr_f.guiarecolhimento 
  left join cgato                    ca on ca.entidade = tg.entidade and ca.idato = tg.fundamentolegal 
order by filtro.dtAtualizacao, 
         filtro.nrcredito, 
         filtro.nranocredito, 
         filtro.idpagamentobloqueto, 
         filtro.iddebitoparcelareceita, 
         filtro.idTipoAtualizacaoCredito
