select x.idtcearrtipocredito,
       x.nrAnoArrecadacao,
       x.idTipoOrigemReceita,
       x.idTipoArrecadacao,
       x.nrCredito,
       x.nranocredito,
       x.nrdivida,
       x.nranodivida,
       x.nrMes,
       x.nrAno,
       sum(x.valor) as valor
from (       
select atc.idtcearrtipocredito,
       atc.nrAnoArrecadacao,
       atc.idTipoOrigemReceita,
       atc.idTipoArrecadacao,
       case when (atc.idTipoOrigemReceita = 1) then tlc.nrcredito else null end as nrCredito,
       case when (atc.idTipoOrigemReceita = 1) then tlc.nranocredito else null end as nranocredito,
       case when (atc.idTipoOrigemReceita = 2) then tid.nrdivida else null end as nrdivida,
       case when (atc.idTipoOrigemReceita = 2) then tid.nranodivida else null end as nranodivida,
       extract(month from tpag.datacredito) as nrMes,
       extract(year  from tpag.datacredito) as nrAno,
       tpd.valorpago as valor
from tceArrecadacaoTipoCredito          atc
join tceArrTipoCreditoPagamento         atcp on atcp.idtcearrtipocredito = atc.idtcearrtipocredito
left join tribpagamentodebito           tpd  on tpd.iddebitoparcelareceita = atcp.iddebitoparcelareceita and tpd.idpagamentobloqueto = atcp.idpagamentobloqueto
left join tribpagamentobloqueto         tpb  on tpb.idpagamentobloqueto  = atcp.idpagamentobloqueto
left join tribpagamento                 tpag on tpag.entidade = tpb.entidade and tpag.exerciciopagamento = tpb.exerciciopagamento and tpag.pagamento = tpb.pagamento
left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = atcp.iddebitoparcelareceita
left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceitaDestino = atcp.iddebitoparcelareceita
left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
where tpag.entidade = :entidade and tpag.datacredito BETWEEN :dataInicial AND :dataFinal
union all
select atc.idtcearrtipocredito,
       atc.nrAnoArrecadacao,
       atc.idTipoOrigemReceita,
       atc.idTipoArrecadacao,
       case when (atc.idTipoOrigemReceita = 1) then tlc.nrcredito else null end as nrCredito,
       case when (atc.idTipoOrigemReceita = 1) then tlc.nranocredito else null end as nranocredito,
       case when (atc.idTipoOrigemReceita = 2) then tid.nrdivida else null end as nrdivida,
       case when (atc.idTipoOrigemReceita = 2) then tid.nranodivida else null end as nranodivida,
       extract(month from tcc.datacredito) as nrMes,
       extract(year  from tcc.datacredito) as nrAno,
       tcci.valorlancado as valor
from tceArrecadacaoTipoCredito          atc
left join tceArrTipoCreditoCredito      atcc on atcc.idtcearrtipocredito = atc.idtcearrtipocredito
left join tribCreditoContribuinteItem   tcci on tcci.idcreditocontribuinteitem = atcc.idcreditocontribuinteitem and tcci.iddebitoparcelareceita = atcc.iddebitoparcelareceita
left join tribcreditocontribuinte       tcc  on tcc.entidade = tcci.entidade and tcc.exercicio = tcci.exercicio and tcc.creditocontribuinte = tcci.creditocontribuinte
left join tribdebitoparcelareceita      tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
left join tribdebitoparcela             tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
                                            and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
                                            and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = atcc.iddebitoparcelareceita
left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceitaDestino = atcc.iddebitoparcelareceita
left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
) x
group by x.idtcearrtipocredito,
       x.nrAnoArrecadacao,
       x.idTipoOrigemReceita,
       x.idTipoArrecadacao,
       x.nrCredito,
       x.nranocredito,
       x.nrdivida,
       x.nranodivida,
       x.nrMes,
       x.nrAno
order by 2,1