/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.peticao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItemDetalhe;
import br.com.elotech.tributos.domain.documento.peticao.SituacaoLotePeticao;
import br.com.elotech.tributos.dto.documento.peticao.CdaGeracaoPeticaoDTO;
import br.com.elotech.tributos.dto.documento.peticao.GeracaoLotePeticaoDTO;
import br.com.elotech.tributos.repository.documento.peticao.LotePeticaoItemRepository;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LotePeticaoService
extends CrudService<LotePeticao, Long> {
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final LotePeticaoItemRepository lotePeticaoItemRepository;

    public LotePeticaoService(CertidaoDividaAtivaService certidaoDividaAtivaService, LotePeticaoItemRepository lotePeticaoItemRepository) {
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.lotePeticaoItemRepository = lotePeticaoItemRepository;
    }

    protected void beforeSave(LotePeticao entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setChildrenId();
    }

    public LotePeticao gerarSimulacao(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO) {
        if (!geracaoLotePeticaoDTO.isValid().booleanValue()) {
            throw new EloValidationException("Filtros invalidos. Informe pelo menos um filtro");
        }
        if (!geracaoLotePeticaoDTO.isDateValid().booleanValue()) {
            throw new EloValidationException("Filtro de data inv\u00e1lido. Deve ser passado ou os dois valores ou nenhum.");
        }
        LotePeticao lotePeticao = new LotePeticao();
        lotePeticao.setDataSimulacao(LocalDate.now());
        lotePeticao.setFiltro(geracaoLotePeticaoDTO.filtro());
        lotePeticao.setAjuizarDebitos(geracaoLotePeticaoDTO.getAjuizarDebitos());
        lotePeticao.setUsuario(UsuarioUtils.getUsuarioAise());
        List itens = this.certidaoDividaAtivaService.findCdaGeracaoPeticao(geracaoLotePeticaoDTO);
        if (itens.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrada nenhuma CDA com os filtros informados.");
        }
        lotePeticao.setSituacao(SituacaoLotePeticao.SIMULACAO_GERADA);
        lotePeticao.setAgruparPorContribuinte(geracaoLotePeticaoDTO.getAgruparPorContribuinte());
        lotePeticao.setItens(this.agruparItens(geracaoLotePeticaoDTO, itens));
        return (LotePeticao)this.save((EloEntity)lotePeticao, null);
    }

    private List<LotePeticaoItem> agruparItens(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO, List<CdaGeracaoPeticaoDTO> cdas) {
        ArrayList<LotePeticaoItem> itensGerados = new ArrayList<LotePeticaoItem>();
        AtomicLong sequencia = new AtomicLong(1L);
        if (geracaoLotePeticaoDTO.getAgruparPorContribuinte().booleanValue()) {
            Map<Long, List<CdaGeracaoPeticaoDTO>> itensAgrupados = cdas.stream().collect(Collectors.groupingBy(CdaGeracaoPeticaoDTO::getPessoa));
            itensAgrupados.forEach((pessoaId, itensAgrupadosPorContribuinte) -> {
                LotePeticaoItem itemGerado = this.buildPeticaoItem(itensAgrupadosPorContribuinte);
                itemGerado.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                itensGerados.add(itemGerado);
            });
        } else {
            List itensNaoAgrupados = cdas.stream().map(itemNaoAgrupado -> {
                LotePeticaoItem itemGerado = this.buildPeticaoItem(Collections.singletonList(itemNaoAgrupado));
                itemGerado.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                return itemGerado;
            }).collect(Collectors.toList());
            itensGerados.addAll(itensNaoAgrupados);
        }
        return itensGerados;
    }

    private LotePeticaoItem buildPeticaoItem(List<CdaGeracaoPeticaoDTO> itens) {
        LotePeticaoItem lotePeticaoItem = new LotePeticaoItem();
        lotePeticaoItem.setDetalhes(itens.stream().map(item -> {
            LotePeticaoItemDetalhe lotePeticaoItemDetalhe = new LotePeticaoItemDetalhe();
            Documento documento = new Documento();
            documento.setId(item.getIdDocumento());
            lotePeticaoItemDetalhe.setDocumento(documento);
            return lotePeticaoItemDetalhe;
        }).collect(Collectors.toList()));
        return lotePeticaoItem;
    }

    public Page<LotePeticaoItem> searchItens(Long idLote, String search, Pageable pageable) {
        String idClause = String.format("lote.id==%d", idLote);
        String searchWithIdClause = search.isEmpty() ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification subQuerySpecification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), LotePeticaoItem.class, (String)searchWithIdClause);
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Subquery subquery = query.subquery(LotePeticaoItem.class);
            Root subQueryRoot = subquery.from(LotePeticaoItem.class);
            subquery.select((Expression)subQueryRoot).where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get("id"), (Expression)subQueryRoot.get("id")), (Expression)subQuerySpecification.toPredicate(subQueryRoot, query, criteriaBuilder)));
            return criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get("lote").get("id"), (Object)idLote), (Expression)criteriaBuilder.exists(subquery));
        };
        return this.lotePeticaoItemRepository.findAll((Specification)specification, pageable);
    }

    public List<LotePeticaoItem> getItensValidos(Long idLotePeticao) {
        return this.lotePeticaoItemRepository.getItensValidos(idLotePeticao);
    }

    protected void beforeDelete(LotePeticao entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (!SituacaoLotePeticao.SIMULACAO_GERADA.equals((Object)entity.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover lote com situa\u00e7\u00e3o diferente de %s", SituacaoLotePeticao.SIMULACAO_GERADA.getDescricao()));
        }
    }
}

