/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.time.LocalDate;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class MovimentacaoMensalJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final NamedParameterJdbcTemplate jdbc;
    @Qualifier(value="movimentacaoMensalBatchJob")
    private final Job movimentacaoMensalBatchJob;

    public MovimentacaoMensalJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, Job movimentacaoMensalBatchJob, NamedParameterJdbcTemplate jdbc) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.movimentacaoMensalBatchJob = movimentacaoMensalBatchJob;
        this.jdbc = jdbc;
    }

    public JobExecution startJob(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio, boolean substituirCargaExistente) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_MOVIMENTACAO_MENSAL.getTipo()).stream().anyMatch(job -> dataInicial.equals(DateUtils.dateToLocalDate((java.util.Date)Objects.requireNonNull(job.getJobParameters().getDate("dataInicial")))) && dataFinal.equals(DateUtils.dateToLocalDate((java.util.Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))) && entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        if (substituirCargaExistente) {
            String sql = FileUtils.readResourceAsString((String)"sql/simam/movimentacaoMensalBatchClear.sql");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("entidade", (Object)entidade);
            params.addValue("dataInicial", (Object)Date.valueOf(dataInicial));
            params.addValue("dataFinal", (Object)Date.valueOf(dataFinal));
            this.jdbc.getJdbcTemplate();
            this.jdbc.execute(sql, (SqlParameterSource)params, PreparedStatement::executeUpdate);
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addDate("dataInicial", DateUtils.localDateToDate((LocalDate)dataInicial));
        jobParametersBuilder.addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal));
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addDate("dataReferencia", new java.util.Date());
        jobParametersBuilder.addLong("exercicio", exercicio);
        return this.jobLauncher.run(this.movimentacaoMensalBatchJob, jobParametersBuilder.toJobParameters());
    }
}

