/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoRepository;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class InscricaoDividaAtivaImplantacaoSaldoJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job inscricaoDividaAtivaImplantacaoSaldoJob;
    private final ImplantacaoSaldoRepository implantacaoSaldoRepository;

    public InscricaoDividaAtivaImplantacaoSaldoJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="inscricaoDividaAtivaImplantacaoSaldoBatch") Job inscricaoDividaAtivaImplantacaoSaldoJob, ImplantacaoSaldoRepository implantacaoSaldoRepository) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.inscricaoDividaAtivaImplantacaoSaldoJob = inscricaoDividaAtivaImplantacaoSaldoJob;
        this.implantacaoSaldoRepository = implantacaoSaldoRepository;
    }

    public JobExecution startJob(Long entidade, Long exercicio) throws Exception {
        Long idControle = this.implantacaoSaldoRepository.findLastIdByExercicio(exercicio);
        if ((long)idControle.compareTo(0L) == 0L) {
            throw new EloValidationException(String.format("\u00c9 necess\u00e1rio gerar os dados para implanta\u00e7\u00e3o de saldo do exerc\u00edcio %d.", exercicio));
        }
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_INSCRICAO_DIVIDA_ATIVA_IMPLANTACAO_SALDO.getTipo()).stream().anyMatch(job -> entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))) && idControle.equals(job.getJobParameters().getLong("idControle")));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("idControle", idControle);
        jobParametersBuilder.addString("implantacaoSaldo", "true");
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.inscricaoDividaAtivaImplantacaoSaldoJob, jobParametersBuilder.toJobParameters());
    }
}

