/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.tarefaassincrona.SituacaoTarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaDTO;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaExecucaoDTO;
import br.com.elotech.tributos.repository.TarefaAssincronaRepository;
import br.com.elotech.tributos.service.TarefaAssincronaExecucaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TarefaAssincronaService {
    private final TarefaAssincronaRepository tarefaAssincronaRepository;
    private final TarefaAssincronaExecucaoService tarefaAssincronaExecucaoService;

    public TarefaAssincronaService(TarefaAssincronaRepository tarefaAssincronaRepository, TarefaAssincronaExecucaoService tarefaAssincronaExecucaoService) {
        this.tarefaAssincronaRepository = tarefaAssincronaRepository;
        this.tarefaAssincronaExecucaoService = tarefaAssincronaExecucaoService;
    }

    public TarefaAssincrona findOne(Long tarefa) {
        return (TarefaAssincrona)this.tarefaAssincronaRepository.findById((Object)tarefa).orElseThrow(() -> new EloValidationException(String.format("Tarefa %s n\u00e3o encontrada.", tarefa)));
    }

    public Page<TarefaAssincronaDTO> searchTarefas(String search, Pageable pageable) {
        return this.tarefaAssincronaRepository.searchTarefas(search, pageable);
    }

    public List<TarefaAssincronaExecucaoDTO> findHistoricoExecucoesByTarefa(Long tarefa) {
        return this.tarefaAssincronaRepository.findHistoricoExecucoesByTarefa(tarefa);
    }

    public void validarTarefaIntegracaoContabilProcessandoComMesmaData(List<LocalDate> datasSelecionadas) {
        List datas = datasSelecionadas.stream().map(LocalDate::toString).collect(Collectors.toList());
        List parametros = this.tarefaAssincronaRepository.getParametrosTarefaIntegracaoContabilProcessandoComMesmaData(datas);
        if (!parametros.isEmpty()) {
            String datasProcessando = parametros.stream().map(parametro -> DateUtils.localDateToStringFormatoBrasileiro((LocalDate)DateUtils.stringToLocalDate((String)parametro.getValor()))).distinct().collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("J\u00e1 existe tarefa sendo processada com a mesma data: %s.", datasProcessando));
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao criarTarefaAssincronaIntegracaoContabil(List<LocalDate> datas) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.INTEGRACAO_CONTABIL_DIA);
        datas.forEach(data -> {
            TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
            parametro.setTarefaAssincrona(tarefa);
            parametro.setTipo(TipoParametro.DATA);
            parametro.setChave("DATA_INTEGRACAO");
            parametro.setValor(DateUtils.DATE_TIME_FORMATTER.format((TemporalAccessor)data));
            tarefa.addParametro(parametro);
        });
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    public TarefaAssincronaExecucao criarNovaExecucao(TarefaAssincrona tarefa) {
        return this.tarefaAssincronaExecucaoService.criarNovaExecucao(tarefa);
    }

    public void marcarExecucaoComErro(TarefaAssincronaExecucao execucao, String mensagemErro) {
        this.tarefaAssincronaExecucaoService.marcarExecucaoComErro(execucao, mensagemErro);
    }

    public void finalizarExecucao(TarefaAssincronaExecucao execucao) {
        this.tarefaAssincronaExecucaoService.finalizarExecucao(execucao);
    }
}

