/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.repository.RastreamentoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.exception.RastreamentoException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RastreamentoService {
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final RastreamentoRepository rastreamentoRepository;
    private final ParametroGeralService parametroGeralService;

    public RastreamentoService(CadastroGeralService cadastroGeralService, RastreamentoRepository rastreamentoRepository, ParametroGeralService parametroGeralService, PessoaService pessoaService) {
        this.cadastroGeralService = cadastroGeralService;
        this.rastreamentoRepository = rastreamentoRepository;
        this.parametroGeralService = parametroGeralService;
        this.pessoaService = pessoaService;
    }

    public Set<RastreamentoCadastroDTO> porCadastro(Long idCadastro) {
        this.validarCadastro((CadastroGeral)this.cadastroGeralService.findOne((Serializable)idCadastro));
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorCadastro(idCadastro, this.consideraCadastroAvulso());
        if (this.consideraDevedorSolidario().booleanValue()) {
            proprietarios.addAll(this.rastreamentoRepository.loadRastreamentoDevedorSolidarioPorCadastro(idCadastro));
        }
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        return this.calculaSituacoesCadastro(cadastros);
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(Long idContribuinte) {
        Pessoa pessoa = this.pessoaService.findOne(idContribuinte);
        this.validarPessoa(pessoa);
        Boolean consideraCnpjRaiz = this.consideraCnpjRaiz();
        Boolean consideraCadastroAvulso = this.consideraCadastroAvulso();
        Boolean consideraSocios = this.consideraSocios();
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorCpfCnpj(pessoa.getCnpjCpf(), consideraCadastroAvulso, consideraCnpjRaiz);
        if (this.consideraDevedorSolidario().booleanValue()) {
            proprietarios.addAll(this.rastreamentoRepository.loadRastreamentoDevedorSolidarioPorCpfCnpj(pessoa.getCnpjCpf(), consideraCnpjRaiz));
        }
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        if (consideraSocios.booleanValue()) {
            cadastros.forEach(cadastro -> {
                List socios = this.rastreamentoRepository.buscaSocios(cadastro.getId());
                socios.forEach(socio -> {
                    Set cadastrosSocios = this.rastreamentoRepository.loadRastreamentoCadastrosSocios(socio.getCpfCnpj(), consideraCnpjRaiz, consideraCadastroAvulso);
                    socio.setCadastrosVinculados(cadastrosSocios.stream().filter(cadastroSocios -> !cadastroSocios.getId().equals(cadastro.getId())).collect(Collectors.toList()));
                });
                cadastro.getProprietarios().addAll(socios);
            });
            cadastros.addAll(this.rastreamentoRepository.loadRastreamentoCadastrosSocios(pessoa.getCnpjCpf(), consideraCnpjRaiz, consideraCadastroAvulso));
        }
        return this.calculaSituacoesCadastro(cadastros);
    }

    private Set<RastreamentoCadastroDTO> calculaSituacoesCadastro(Set<RastreamentoCadastroDTO> cadastros) {
        Boolean parametroCertidaoNegativaSemContrato = this.consideraCndParaDebitosAVencer();
        Boolean parametroConsideraContencioso = this.consideraContencioso();
        HashMap mapCadastros = new HashMap();
        cadastros.forEach(cadastro -> {
            this.atualizaSituacoesCadastro(mapCadastros, cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso);
            cadastro.getProprietarios().forEach(proprietario -> {
                if (Objects.nonNull(proprietario.getCadastrosVinculados())) {
                    proprietario.getCadastrosVinculados().forEach(cadastroVinculado -> this.atualizaSituacoesCadastro(mapCadastros, cadastroVinculado, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
                }
            });
        });
        return cadastros;
    }

    private void atualizaSituacoesCadastro(Map<Long, RastreamentoCadastroDTO> mapCadastros, RastreamentoCadastroDTO cadastro, Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        RastreamentoCadastroDTO cadastroMapeado = mapCadastros.computeIfAbsent(cadastro.getId(), c -> this.buscaDebitos(cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
        cadastro.setDebitos(cadastroMapeado.getDebitos());
        cadastro.setTipoCertidaoDebitos(cadastroMapeado.getTipoCertidaoDebitos());
    }

    private RastreamentoCadastroDTO buscaDebitos(RastreamentoCadastroDTO cadastro, Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        cadastro.setDebitos(this.rastreamentoRepository.loadDebitosRastreamento(cadastro.getId()));
        cadastro.calculaSituacaoDebitos(parametroCertidaoNegativaSemContrato, parametroConsideraContencioso);
        return cadastro;
    }

    private void validarCadastro(CadastroGeral cadastro) {
        if (Objects.isNull(cadastro)) {
            throw new CadastroNaoEncontradoException();
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastro.getTipoCadastro())) {
            throw RastreamentoException.tipoCadastroInvalido();
        }
    }

    private void validarPessoa(Pessoa pessoa) {
        if (Objects.isNull(pessoa)) {
            throw new PessoaNotFoundException();
        }
    }

    private Boolean consideraCadastroAvulso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_AVULSO_RASTREAMENTO);
    }

    private Boolean consideraDevedorSolidario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_DEVEDOR_SOLIDARIO_CND);
    }

    private Boolean consideraCndParaDebitosAVencer() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CERTIDAO_CND_QDO_SEM_CONTRATO);
    }

    private Boolean consideraCnpjRaiz() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CNPJ_RAIZ_RASTREAMENTO);
    }

    private Boolean consideraSocios() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_SOCIO_RASTREAMENTO);
    }

    private Boolean consideraContencioso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTENCIOSO_CND);
    }
}

