/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.DividaFormaPagamentoConvenioDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DividaFormaPagamentoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ValidaEmissaoBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.CodigoBarrasException;
import br.com.elotech.tributos.service.exception.ConvenioBoletoNotFoundException;
import br.com.elotech.tributos.service.exception.DividaFormaPagamentoException;
import br.com.elotech.tributos.service.exception.FormaPagamentoPadraoNotFoundException;
import br.com.elotech.tributos.service.exception.GeraBoletoException;
import br.com.elotech.tributos.service.exception.ModeloBoletoNotFoundException;
import br.com.elotech.tributos.service.exception.NossoNumeroException;
import br.com.elotech.tributos.service.exception.TipoCodigoBarrasBoletoNotFoundException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistradoReceiver;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoService;
import com.google.common.base.Predicates;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeraBoletoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeraBoletoService.class);
    private final BoletoRepository boletoRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final ContextService contextService;
    private final CadastroGeralService cadastroGeralService;
    private final DividaFormaPagamentoService dividaFormaPagamentoService;
    private final ValidaEmissaoBoletoService validaEmissaoBoletoService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final ParametroGeralService parametroGeralService;
    private final IntegracaoBoletoService integracaoBoletoService;
    private final IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver;

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, Boolean somenteDebitosConstituidos) {
        return this.geraBoleto(geraBoletoDTO, this.getFormaPagamento(), somenteDebitosConstituidos);
    }

    private void verificaDataReferenciaGuiaAgrupada(GeraBoletoDTO geraBoletoDTO) {
        Boolean utilizaDataReferencia = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.DATA_REFERENCIA_GUIA_AGRUPADA);
        if (Boolean.TRUE.equals(geraBoletoDTO.getImpressaoCarne()) || !utilizaDataReferencia.booleanValue() && Objects.isNull(geraBoletoDTO.getDataReferencia())) {
            geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        }
        if (Objects.nonNull(geraBoletoDTO.getDataReferencia()) && geraBoletoDTO.getDataReferencia().isBefore(this.contextService.getDataAtual())) {
            throw GeraBoletoException.dataReferenciaMenor();
        }
    }

    @Transactional(noRollbackFor={Exception.class})
    public List<Bloqueto> geraBoletoCarneCalculo(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, Boolean somenteDebitosConstituidos) {
        return this.geraBoleto(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos);
    }

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, Boolean somenteDebitosConstituidos) {
        this.verificaDataReferenciaGuiaAgrupada(geraBoletoDTO);
        Long exercicioBoleto = Objects.nonNull(geraBoletoDTO.getExercicio()) ? geraBoletoDTO.getExercicio() : this.contextService.getExercicioAtual();
        List listDebitoEmAberto = this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro(geraBoletoDTO.getDebitos()), somenteDebitosConstituidos);
        this.validaEmissaoBoleto(exercicioBoleto, formaPagamento, listDebitoEmAberto);
        List geracaoBoleto = this.agregaDebitoPorTipoBoleto(geraBoletoDTO.getTipoBoleto(), listDebitoEmAberto);
        return geracaoBoleto.stream().map(debitos -> this.createBoleto(geraBoletoDTO, exercicioBoleto, formaPagamento, debitos, Boolean.FALSE)).collect(Collectors.toList());
    }

    public List<Bloqueto> geraBoletoSuperSimples(GeraBoletoDTO geraBoletoDTO) {
        Long formaPagamento = this.getFormaPagamento();
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Boolean somenteConstituidos = Boolean.FALSE;
        geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        List listDebitoEmAberto = this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro(geraBoletoDTO.getDebitos()), somenteConstituidos);
        this.validaEmissaoBoleto(exercicioAtual, formaPagamento, listDebitoEmAberto);
        List geracaoBoleto = this.agregaDebitoPorTipoBoleto(geraBoletoDTO.getTipoBoleto(), listDebitoEmAberto);
        return geracaoBoleto.stream().map(debitos -> this.createBoleto(geraBoletoDTO, exercicioAtual, formaPagamento, debitos, Boolean.TRUE)).collect(Collectors.toList());
    }

    private void validaEmissaoBoleto(Long exercicioAtual, Long formaPagamento, List<DebitoEmAbertoDTO> listaDebitosBoletoDTO) {
        if (listaDebitosBoletoDTO.isEmpty()) {
            throw GeraBoletoException.debitoNaoEmiteBoleto();
        }
        List listDividaFormaPagamentoConvenio = this.dividaFormaPagamentoService.findDividaFormaPagamentoByIdDebitoAndFormaPagamentoAndExercicio(listaDebitosBoletoDTO.stream().map(CalculaAcrescimoBaseDTO::getIdDebito).collect(Collectors.toList()), formaPagamento, exercicioAtual);
        this.validaFormaPagamento(listDividaFormaPagamentoConvenio, formaPagamento);
        this.validaConvenio(listDividaFormaPagamentoConvenio);
        this.validaEmissaoBoletoService.validaEmissaoBoleto(listaDebitosBoletoDTO);
    }

    private Bloqueto createBoleto(GeraBoletoDTO geraBoletoDTO, Long exercicioAtual, Long formaPagamento, List<DebitoEmAbertoDTO> debitos, Boolean isSuperSimples) {
        Convenio convenio;
        DebitoEmAbertoDTO debitoEmAbertoDTO = (DebitoEmAbertoDTO)debitos.stream().findFirst().orElseThrow(BoletoException::debitoBoletoNotFound);
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debitoEmAbertoDTO.getTipoCadastro()), debitoEmAbertoDTO.getCadastroGeral()).orElseThrow(() -> new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)debitoEmAbertoDTO.getTipoCadastro()), debitoEmAbertoDTO.getCadastroGeral()));
        DividaFormaPagamento dividaFormaPagamento = this.dividaFormaPagamentoService.findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(debitoEmAbertoDTO.getEntidade(), exercicioAtual, debitoEmAbertoDTO.getDivida(), formaPagamento);
        ModeloBoleto modeloBoleto = Optional.ofNullable(dividaFormaPagamento.getModeloBoleto()).orElseThrow(() -> new ModeloBoletoNotFoundException(debitoEmAbertoDTO.getEntidade(), exercicioAtual, debitoEmAbertoDTO.getDivida(), formaPagamento));
        if (!Optional.ofNullable(modeloBoleto.getConvenio()).isPresent()) {
            throw new ConvenioBoletoNotFoundException(modeloBoleto.getId());
        }
        if (!Optional.ofNullable(modeloBoleto.getConvenio().getTipoCodigoBarras()).isPresent()) {
            throw new TipoCodigoBarrasBoletoNotFoundException(modeloBoleto.getConvenio().getId());
        }
        Bloqueto boleto = new Bloqueto();
        boleto.setOrigemEmissao(OrigemEmissao.AISE);
        boleto.setEntidade(this.contextService.getEntidadePrincipal());
        boleto.setExercicioBloqueto(exercicioAtual);
        boleto.setTipoBloqueto(geraBoletoDTO.getTipoBoleto());
        boleto.setDataEmissao(this.contextService.getDataAtual());
        boleto.setDireitoDescontoCotaUnica(Boolean.FALSE);
        boleto.setUtilizaValorBloqueto(Boolean.FALSE);
        if (TipoBloqueto.COTA_UNICA.equals((Object)geraBoletoDTO.getTipoBoleto())) {
            boleto.setDataVencimento(dividaFormaPagamento.getVencimento());
            boleto.setDataLimitePagamento(dividaFormaPagamento.getVencimento());
        } else {
            LocalDate menorDataVencimento = debitos.stream().map(CalculaAcrescimoBaseDTO::getDataVencimento).min(Comparator.comparing(LocalDate::toEpochDay)).orElseThrow(BoletoException::debitoBoletoNotFound);
            if (isSuperSimples.booleanValue()) {
                boleto.setDataVencimento(menorDataVencimento);
                boleto.setDataLimitePagamento(menorDataVencimento);
            } else {
                boleto.setDataVencimento(this.calcularDataVencimento(geraBoletoDTO.getDataReferencia(), menorDataVencimento));
                boleto.setDataLimitePagamento(this.getDataLimiteVencimento(geraBoletoDTO.getTipoBoleto(), boleto.getDataVencimento(), dividaFormaPagamento));
            }
        }
        boleto.setUsuario(SecurityUtils.getUserAise());
        boleto.setFormaPagamento(formaPagamento);
        boleto.setModeloBloqueto(modeloBoleto);
        boleto.setObservacao(geraBoletoDTO.getObservacao());
        boleto.setCadastroGeral(cadastroGeral);
        boleto.setPessoa(this.getPessoaBoleto(cadastroGeral));
        if (Objects.nonNull(geraBoletoDTO.getMotivoDeducao())) {
            MotivoDeducao motivoDeducao = (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)geraBoletoDTO.getMotivoDeducao()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o motivo dedu\u00e7\u00e3o %d.", geraBoletoDTO.getMotivoDeducao().intValue())));
            boleto.setMotivoDeducao(motivoDeducao);
        }
        this.boletoRepository.geraCodigoBoleto(boleto);
        List debitosEmAberto = isSuperSimples != false ? debitos : this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento, geraBoletoDTO.getImpressaoCarne() != false ? geraBoletoDTO.getDataReferencia() : boleto.getDataVencimento());
        boleto.getDebitos().addAll(debitosEmAberto.stream().map(boletoDebitoDTO -> {
            DebitoParcelaTributo debitoParcelaTributo = (DebitoParcelaTributo)this.debitoParcelaTributoService.findById((Serializable)boletoDebitoDTO.getIdDebitoParcelaReceita()).orElseThrow(() -> new EloValidationException(String.format("Debito Parcela Tributo %d n\u00e3o encontrado.", boletoDebitoDTO.getIdDebitoParcelaReceita())));
            return BoletoDebito.of((Bloqueto)boleto, (DebitoParcelaTributo)debitoParcelaTributo, (DebitoEmAbertoDTO)boletoDebitoDTO);
        }).collect(Collectors.toList()));
        boleto.atualizaValoresBoleto();
        if (boleto.getValorDesconto().compareTo(BigDecimal.ZERO) > 0 && Objects.isNull(boleto.getMotivoDeducao())) {
            if (Objects.isNull(dividaFormaPagamento.getMotivoDeducao())) {
                throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o boleto, pois este possui valor de desconto mas n\u00e3o possui motivo de desconto configurado. Forma pagamento %d, d\u00edvida %d, exerc\u00edcio de %d.", formaPagamento, debitoEmAbertoDTO.getDivida(), exercicioAtual));
            }
            boleto.setMotivoDeducao(dividaFormaPagamento.getMotivoDeducao());
        }
        CodigoBarrasDTO codigoBarrasDTO = Boolean.TRUE.equals((convenio = modeloBoleto.getConvenio()).getRegistraBoletoOnline()) ? this.integracaoBoletoRegistradoReceiver.receiveRequest(boleto) : convenio.getTipoCodigoBarras().getNossoNumero().gerar(boleto);
        this.validaDadosCodigoBarras(codigoBarrasDTO);
        boleto.setCodigoBarras(codigoBarrasDTO);
        boleto.setNossoNumero(codigoBarrasDTO.getNossoNumero());
        Bloqueto boletoSalvo = (Bloqueto)this.boletoRepository.save((Object)boleto);
        try {
            if (Boolean.TRUE.equals(boletoSalvo.getModeloBloqueto().getConvenio().getUtilizaPix())) {
                boletoSalvo = this.integracaoBoletoService.gerarQrCodePix(boletoSalvo);
                boletoSalvo = (Bloqueto)this.boletoRepository.save((Object)boletoSalvo);
            }
        }
        catch (Exception e) {
            log.error("Erro ao gerar o codigo qrcode do pix", (Throwable)e);
        }
        return boletoSalvo;
    }

    public void validaConvenio(List<DividaFormaPagamentoConvenioDTO> listDividaFormaPagamentoConvenio) {
        listDividaFormaPagamentoConvenio.stream().filter(Predicates.not(DividaFormaPagamentoConvenioDTO::hasConvenio)).findAny().ifPresent(debito -> {
            throw new GeraBoletoException(String.format("N\u00e3o h\u00e1 conv\u00eanio configurado para d\u00edvida %d.", debito.getDivida()));
        });
        if (listDividaFormaPagamentoConvenio.stream().collect(Collectors.groupingBy(DividaFormaPagamentoConvenioDTO::getConvenio)).size() > 1) {
            throw new GeraBoletoException("As d\u00edvidas selecionadas s\u00e3o de conv\u00eanios diferentes.");
        }
    }

    private List<List<DebitoEmAbertoDTO>> agregaDebitoPorTipoBoleto(TipoBloqueto tipoBoleto, List<DebitoEmAbertoDTO> listaDebitosBoletoDTO) {
        ArrayList<List<DebitoEmAbertoDTO>> debitosAgrupadosPorBoleto = new ArrayList<List<DebitoEmAbertoDTO>>();
        if (TipoBloqueto.PARCELADO.equals((Object)tipoBoleto)) {
            Map<Long, Map<Long, List<DebitoEmAbertoDTO>>> debitosAgrupadosPorParcela = listaDebitosBoletoDTO.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getIdDebito, Collectors.groupingBy(CalculaAcrescimoBaseDTO::getParcela)));
            debitosAgrupadosPorParcela.forEach((idDebito, parcelas) -> parcelas.forEach((parcela, values) -> debitosAgrupadosPorBoleto.add((List<DebitoEmAbertoDTO>)values)));
            return debitosAgrupadosPorBoleto;
        }
        if (TipoBloqueto.COTA_UNICA.equals((Object)tipoBoleto)) {
            Map<Long, List<DebitoEmAbertoDTO>> debitosAgrupadosPorDebito = listaDebitosBoletoDTO.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getIdDebito));
            debitosAgrupadosPorDebito.forEach((idDebito, debito) -> debitosAgrupadosPorBoleto.add((List<DebitoEmAbertoDTO>)debito));
            return debitosAgrupadosPorBoleto;
        }
        debitosAgrupadosPorBoleto.add(listaDebitosBoletoDTO);
        return debitosAgrupadosPorBoleto;
    }

    public LocalDate getDataLimiteVencimentoBoletoEspecial(Bloqueto boleto, Long divida, Long formaPagamento) {
        if (TipoBloqueto.PARCELADO.equals((Object)boleto.getTipoBloqueto())) {
            DividaFormaPagamento dividaFormaPagamento = this.dividaFormaPagamentoService.findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(boleto.getEntidade(), boleto.getExercicioBloqueto(), divida, formaPagamento);
            return Optional.ofNullable(dividaFormaPagamento).map(DividaFormaPagamento::getValidade).map(validade -> boleto.getDataVencimento().plusDays((long)validade)).orElse(boleto.getDataVencimento());
        }
        return boleto.getDataVencimento();
    }

    public LocalDate getDataLimiteVencimento(TipoBloqueto tipoBloqueto, LocalDate dataVencimento, DividaFormaPagamento dividaFormaPagamento) {
        if (TipoBloqueto.PARCELADO.equals((Object)tipoBloqueto) && Objects.nonNull(dividaFormaPagamento.getValidade())) {
            return dataVencimento.plusDays(dividaFormaPagamento.getValidade());
        }
        return dataVencimento;
    }

    public Long getFormaPagamento() {
        return Long.valueOf(Optional.ofNullable(this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.FORMA_PAGAMENTO_PADRAO.getValue())).orElseThrow(FormaPagamentoPadraoNotFoundException::new).getValor());
    }

    private LocalDate calcularDataVencimento(LocalDate dataReferencia, LocalDate dataVencimentoParcela) {
        return Objects.isNull(dataReferencia) || dataVencimentoParcela.isAfter(dataReferencia) ? dataVencimentoParcela : dataReferencia;
    }

    public void validaFormaPagamento(List<DividaFormaPagamentoConvenioDTO> listDividaFormaPagamentoConvenio, Long formaPagamento) {
        listDividaFormaPagamentoConvenio.stream().filter(Predicates.not(DividaFormaPagamentoConvenioDTO::hasFormaPagamento)).findAny().ifPresent(debito -> {
            throw new DividaFormaPagamentoException(debito.getDivida(), formaPagamento);
        });
    }

    public void validaDadosCodigoBarras(CodigoBarrasDTO dto) {
        if (!Optional.ofNullable(dto.getNossoNumero()).isPresent() || dto.getNossoNumero().isEmpty()) {
            throw new NossoNumeroException();
        }
        if (!Optional.ofNullable(dto.getCodigoBarras()).isPresent() || dto.getCodigoBarras().isEmpty()) {
            throw new CodigoBarrasException();
        }
        if (!Optional.ofNullable(dto.getLinhaDigitavel()).isPresent() || dto.getLinhaDigitavel().isEmpty()) {
            throw NossoNumeroException.linhaDigitavelNotFound();
        }
    }

    public Pessoa getPessoaBoleto(CadastroGeral cadastroGeral) {
        if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            return cadastroGeral.getPessoa();
        }
        Optional<Proprietario> proprietario = cadastroGeral.getProprietarios().stream().filter(prop -> Boolean.TRUE.equals(prop.getCoResponsavelPrincipal()) && Objects.nonNull(prop.getVinculo()) && TipoVinculo.SOCIO.equals((Object)prop.getVinculo().getTipoVinculo())).findFirst();
        if (proprietario.isPresent()) {
            return proprietario.get().getPessoa();
        }
        proprietario = cadastroGeral.getProprietarios().stream().filter(prop -> Boolean.TRUE.equals(prop.getPrincipal()) && Objects.nonNull(prop.getVinculo()) && TipoVinculo.PRINCIPAL.equals((Object)prop.getVinculo().getTipoVinculo())).findFirst();
        if (proprietario.isPresent()) {
            return proprietario.get().getPessoa();
        }
        return cadastroGeral.getPessoa();
    }

    private String mountFiltro(List<DebitoParcelaDTO> parcelas) {
        return parcelas.stream().map(parcela -> String.format(" (tribdebito.iddebito = %d  and tribdebitoparcela.parcela = %d) ", parcela.getIdDebito(), parcela.getParcela())).collect(Collectors.joining(" or "));
    }

    public void validaModeloBoleto(ModeloBoleto modeloBoleto) {
        if (!Optional.ofNullable(modeloBoleto.getConvenio()).isPresent()) {
            throw new ConvenioBoletoNotFoundException(modeloBoleto.getId());
        }
        if (!Optional.ofNullable(modeloBoleto.getConvenio().getTipoCodigoBarras()).isPresent()) {
            throw new TipoCodigoBarrasBoletoNotFoundException(modeloBoleto.getConvenio().getId());
        }
    }

    @Generated
    public GeraBoletoService(BoletoRepository boletoRepository, CalculoAcrescimoService calculoAcrescimoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, ContextService contextService, CadastroGeralService cadastroGeralService, DividaFormaPagamentoService dividaFormaPagamentoService, ValidaEmissaoBoletoService validaEmissaoBoletoService, DebitoEmAbertoService debitoEmAbertoService, DebitoParcelaTributoService debitoParcelaTributoService, MotivoDeducaoService motivoDeducaoService, ParametroGeralService parametroGeralService, IntegracaoBoletoService integracaoBoletoService, IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver) {
        this.boletoRepository = boletoRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.contextService = contextService;
        this.cadastroGeralService = cadastroGeralService;
        this.dividaFormaPagamentoService = dividaFormaPagamentoService;
        this.validaEmissaoBoletoService = validaEmissaoBoletoService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.parametroGeralService = parametroGeralService;
        this.integracaoBoletoService = integracaoBoletoService;
        this.integracaoBoletoRegistradoReceiver = integracaoBoletoRegistradoReceiver;
    }
}

