/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.repository.ConsultaDebitoRepository;
import br.com.elotech.tributos.service.BatchService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.List;
import org.springframework.batch.core.JobParameters;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ConsultaDebitoBatchService
extends CrudService<ConsultaDebito, Long> {
    private final ConsultaDebitoRepository consultaDebitoRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final BatchService batchService;
    private final ObjectMapper objectMapper;

    public ConsultaDebitoBatchService(ConsultaDebitoRepository consultaDebitoRepository, CalculoAcrescimoService calculoAcrescimoService, BatchService batchService, ObjectMapper objectMapper) {
        this.consultaDebitoRepository = consultaDebitoRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.batchService = batchService;
        this.objectMapper = objectMapper;
    }

    public void calcularAcrescimos(List<DebitoConstituidoItemDTO> debitoConstituidoItem, FormaPagamento formaPagamentoPadrao, LocalDate dataReferencia) {
        debitoConstituidoItem.forEach(debito -> {
            AcrescimoDTO acrescimo = this.calculoAcrescimoService.calculaAcrescimos(AcrescimoDTO.of((DebitoConstituidoItemDTO)debito, (Long)formaPagamentoPadrao.getId(), (LocalDate)dataReferencia));
            debito.setValor(acrescimo.getValor());
            debito.setValorJuros(acrescimo.getValorJuros());
            debito.setValorMulta(acrescimo.getValorMulta());
            debito.setValorCorrecao(acrescimo.getValorCorrecao());
            debito.setValorLiquido(acrescimo.getValorTotal());
        });
    }

    public ConsultaDebito create(ConsultaDebito consultaDebito) {
        return (ConsultaDebito)this.consultaDebitoRepository.save((Object)consultaDebito);
    }

    public Page<ConsultaDebitoItemDTO> getDebitos(Long idConsulta, String tipoAgrupamento, Pageable pageable) {
        return this.consultaDebitoRepository.findDebitos(idConsulta, tipoAgrupamento, pageable);
    }

    public ConsultaDebitoValoresDTO getResumo(Long idConsulta) {
        return this.consultaDebitoRepository.getResumo(idConsulta);
    }

    public FiltroConsultaDebitoDTO getFiltro(Long idConsulta) throws JsonProcessingException {
        JobParameters jobParameters = this.findJobParametersById(idConsulta);
        String filtro = jobParameters.getString("filtro");
        return (FiltroConsultaDebitoDTO)this.objectMapper.readValue(filtro, FiltroConsultaDebitoDTO.class);
    }

    private JobParameters findJobParametersById(Long idConsulta) {
        ConsultaDebito consultaDebito = (ConsultaDebito)this.consultaDebitoRepository.findById((Object)idConsulta).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a consulta de d\u00e9bitos com id %d", idConsulta)));
        return this.batchService.getJobParametersById(consultaDebito.getBatchJobExecution().getId());
    }
}

