/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.dto.ComunicadoDTO;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoService
extends CrudService<Comunicado, ComunicadoId> {
    private final ComunicadoRepository comunicadoRepository;

    public Page<ComunicadoDTO> search(String search, Pageable pageable) {
        return this.findByRsql(search, pageable).map(ComunicadoDTO::from);
    }

    public Comunicado cancelarComunicado(Long entidade, Long exercicio, Long idComunicado) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (comunicado.getSituacao().equals((Object)SituacaoComunicado.CANCELADO)) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
        this.comunicadoRepository.updateComunicadoCadastro(entidade, exercicio, idComunicado);
        this.comunicadoRepository.updateComunicado(entidade, exercicio, idComunicado);
        comunicado.setSituacao(SituacaoComunicado.CANCELADO);
        return comunicado;
    }

    @Generated
    public ComunicadoService(ComunicadoRepository comunicadoRepository) {
        this.comunicadoRepository = comunicadoRepository;
    }
}

