/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoDetalheDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoFiltroDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoResumoDTO;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arrecadacao"})
public class ArrecadacaoResource {
    private final ArrecadacaoService arrecadacaoService;

    public ArrecadacaoResource(ArrecadacaoService arrecadacaoService) {
        this.arrecadacaoService = arrecadacaoService;
    }

    @PostMapping(value={"/arrecadacao-por-tipo"})
    public ResponseEntity<ArrecadacaoPorTipoResumoDTO> consultaArrecadacaoPorTipo(@Valid @RequestBody ArrecadacaoPorTipoFiltroDTO filtro) {
        return ResponseEntity.ok((Object)this.arrecadacaoService.consultaResumoArrecadacao(filtro));
    }

    @PostMapping(value={"/arrecadacao-por-tipo-detalhe"})
    public ResponseEntity<Page<ArrecadacaoPorTipoDetalheDTO>> consultaArrecadacaoPorTipoDetalhe(@Valid @RequestBody ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoService.consultaResumoArrecadacaoPorTipoDetalhe(filtro, pageable));
    }
}

