/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.ParametroItbiDTO;
import br.com.elotech.tributos.dto.ParametroItbiFlatDTO;
import br.com.elotech.tributos.service.ParametroItbiService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-itbi"})
public class ParametroItbiResource {
    private final ParametroItbiService parametroItbiService;

    public ParametroItbiResource(ParametroItbiService parametroItbiService) {
        this.parametroItbiService = parametroItbiService;
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ParametroItbiDTO> findOne(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.parametroItbiService.findOneDTO(id));
    }

    @GetMapping
    public ResponseEntity<Page<ParametroItbiDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.parametroItbiService.searchDto(search, pageable));
    }

    @GetMapping(value={"/exercicio-atual"})
    public ResponseEntity<ParametroItbiFlatDTO> findByEntidadeAndExercicio() {
        return ResponseEntity.ok((Object)this.parametroItbiService.getParametroItbiExercicioAtual());
    }

    @PostMapping
    public ResponseEntity<ParametroItbiDTO> create(@RequestBody ParametroItbiDTO dto) {
        return ResponseEntity.ok((Object)this.parametroItbiService.create(dto));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<ParametroItbiDTO> update(@PathVariable Long id, @RequestBody ParametroItbiDTO dto) {
        return ResponseEntity.ok((Object)this.parametroItbiService.update(id, dto));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<ParametroItbiDTO> delete(@PathVariable Long id) {
        this.parametroItbiService.delete(id);
        return ResponseEntity.noContent().build();
    }
}

