/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCredito;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoRestituicaoDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoRestituicaoResumoDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoResumoDTO;
import br.com.elotech.tributos.service.DevolucaoCreditoService;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/devolucao-credito"})
public class DevolucaoCreditoResource {
    private final DevolucaoCreditoService devolucaoCreditoService;

    public DevolucaoCreditoResource(DevolucaoCreditoService devolucaoCreditoService) {
        this.devolucaoCreditoService = devolucaoCreditoService;
    }

    @GetMapping
    public ResponseEntity<Page<DevolucaoCreditoRestituicaoDTO>> search(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.devolucaoCreditoService.getDevolucaoCreditos(search, page));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<DevolucaoCreditoResumoDTO> getResumo(@PathVariable(value="id") Long id) {
        DevolucaoCredito devolucaoCredito = (DevolucaoCredito)this.devolucaoCreditoService.findById((Serializable)id).orElseThrow(() -> RestException.status((HttpStatus)HttpStatus.NOT_FOUND, (String)String.format("N\u00e3o foi poss\u00edvel encontrar a devolu\u00e7\u00e3o de cr\u00e9dito com id %d", id)));
        return ResponseEntity.ok((Object)DevolucaoCreditoResumoDTO.from((DevolucaoCredito)devolucaoCredito));
    }

    @PostMapping
    public ResponseEntity<DevolucaoCredito> save(@RequestBody DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO) {
        return ResponseEntity.ok((Object)this.devolucaoCreditoService.saveDevolucaoCredito(devolucaoCreditoRestituicaoDTO));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<DevolucaoCredito> update(@PathVariable(value="id") Long id, @RequestBody DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO) {
        return ResponseEntity.ok((Object)this.devolucaoCreditoService.updateDevolucaoCredito(devolucaoCreditoRestituicaoDTO, id));
    }

    @PutMapping(value={"/confirmar-devolucao/{id}"})
    public ResponseEntity<DevolucaoCredito> confirmDevolucao(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.devolucaoCreditoService.confirmDevolucao(id));
    }
}

