/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.DebitoParcelaObservacaoId;
import br.com.elotech.tributos.dto.DebitoParcelaObservacaoDTO;
import br.com.elotech.tributos.service.DebitoParcelaObservacaoService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debito-parcelas-observacoes"})
public class DebitoParcelaObservacaoResource {
    private final DebitoParcelaObservacaoService debitoParcelaObservacaoService;

    public DebitoParcelaObservacaoResource(DebitoParcelaObservacaoService debitoParcelaObservacaoService) {
        this.debitoParcelaObservacaoService = debitoParcelaObservacaoService;
    }

    @GetMapping(value={"/by-debito"}, params={"entidade", "exercicio", "tipoCadastro", "cadastroGeral", "divida", "subDivida", "parcela"})
    public ResponseEntity<List<DebitoParcelaObservacao>> findByDebitoParcela(DebitoParcelaObservacaoId params) {
        return ResponseEntity.ok((Object)this.debitoParcelaObservacaoService.findByDebitoParcela(params.getEntidade(), params.getExercicio(), params.getTipoCadastro(), params.getCadastroGeral(), params.getDivida(), params.getSubDivida(), params.getParcela()));
    }

    @PostMapping
    public ResponseEntity<DebitoParcelaObservacao> saveObservacaoParcela(@RequestBody @Valid DebitoParcelaObservacaoDTO observacaoDTO) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.debitoParcelaObservacaoService.saveObservacaoParcela(observacaoDTO));
    }
}

