/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.dto.ComunicadoDTO;
import br.com.elotech.tributos.service.ComunicadoService;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/comunicados"})
public class ComunicadoResource
extends CrudResource<Comunicado, ComunicadoId> {
    private final ComunicadoService comunicadoService;

    @GetMapping(value={"/id/{entidade}/{exercicio}/{idComunicado}"})
    public ResponseEntity<ComunicadoDTO> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        Comunicado comunicado = (Comunicado)this.comunicadoService.findById((Serializable)ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado)).orElseThrow(RestException::notFound);
        return ResponseEntity.ok((Object)ComunicadoDTO.from((Comunicado)comunicado));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ComunicadoDTO>> searchCampos(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.comunicadoService.search(search, pageable));
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{idComunicado}/cancelar"})
    public ResponseEntity<ComunicadoDTO> cancelarComunicado(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        Comunicado comunicado = this.comunicadoService.cancelarComunicado(entidade, exercicio, idComunicado);
        return ResponseEntity.ok((Object)ComunicadoDTO.from((Comunicado)comunicado));
    }

    @Generated
    public ComunicadoResource(ComunicadoService comunicadoService) {
        this.comunicadoService = comunicadoService;
    }
}

