/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.InscricaoDividaAtivaDTO;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class InscricaoCreditoDividaAtivaCustomRepositoryImpl
implements InscricaoCreditoDividaAtivaCustomRepository {
    private final String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/inscricaoDividaAtivaLancamentos.sql");
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public InscricaoCreditoDividaAtivaCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<InscricaoDividaAtivaDTO> findLancamentos(Long entidade, Long idPessoa, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("idPessoa", (Object)idPessoa);
        parameters.addValue("dataInicial", (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue("dataFinal", (Object)Date.valueOf(dataFinal), 91);
        return this.namedParameterJdbcTemplate.query(this.sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(InscricaoDividaAtivaDTO.class));
    }
}

