/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaDAParcelamentoDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaDAParcelamentoNrDividaDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoParcelamentoDACustomRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoMonetariaCreditoParcelamentoDACustomRepositoryImpl
implements AtualizacaoMonetariaCreditoParcelamentoDACustomRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoMonetariaDAParcelamentoDTO> loadParcelamentoDA(String receitaPrincipal, Long idParcelamento) {
        String sqlParcelamentoReceita = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoMonetariaDAParcelamento.sql");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("receitaPrincipal", (Object)receitaPrincipal);
        parameters.addValue("idparcelamento", (Object)idParcelamento);
        return this.namedParameterJdbcTemplate.query(sqlParcelamentoReceita, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoMonetariaDAParcelamentoDTO.class));
    }

    public List<AtualizacaoMonetariaDAParcelamentoNrDividaDTO> loadParcelamentoDANrDivida(ClassificacaoTributo classificacao, Long idParcelamento, String receitaPrincipal, String receita) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("receitaPrincipal", (Object)receitaPrincipal);
        parameters.addValue("idparcelamento", (Object)idParcelamento);
        parameters.addValue("receita", (Object)receita);
        parameters.addValue("classificacao", (Object)classificacao.getValue());
        Object sqlParcelamentoReceita = "select distinct tppro.idparcelamento,        tppro.iddebitoparcelareceita,        tppro.percentual,        tid.nrdivida,        tid.nranodivida from tribParcelamentoParcRecOrigem tppro left join tceDebitoInscCreditoDA        tdic on tdic.iddebitoparcelareceitadestino = tppro.iddebitoparcelareceita left join tceInscCreditoDA              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda join tribdebitoparcelareceita      tdpr on tdpr.iddebitoparcelareceita = tppro.iddebitoparcelareceita join tribguiarecolhimentoreceita   tgrr on tgrr.entidade = tdpr.entidade and tgrr.exercicio = tdpr.exercicio                                        and tgrr.guiarecolhimento = tdpr.guiarecolhimento and tgrr.receita = tdpr.receita join tribguiareceitaespelho        tgre on tgre.entidade = tgrr.entidade and tgre.exercicio = tgrr.exercicio                                        and tgre.guiarecolhimento = tgrr.guiarecolhimento and tgre.receita = tgrr.receita where tppro.idparcelamento = :idparcelamento ";
        if (ClassificacaoTributo.JUROS.equals((Object)classificacao)) {
            sqlParcelamentoReceita = (String)sqlParcelamentoReceita + " and tgre.jurosdestino = :receita ";
        }
        if (ClassificacaoTributo.MULTA.equals((Object)classificacao)) {
            sqlParcelamentoReceita = (String)sqlParcelamentoReceita + " and tgre.multadestino = :receita ";
        }
        if (ClassificacaoTributo.CORRECAO.equals((Object)classificacao)) {
            sqlParcelamentoReceita = (String)sqlParcelamentoReceita + " and tgre.correcaodestino = :receita ";
        }
        sqlParcelamentoReceita = (String)sqlParcelamentoReceita + "and tgre.receita = :receitaPrincipal   and not exists (    select 1    from tceAtualizaMoneParcDA tamp    where tamp.idParcelamento = tppro.idParcelamento      and tamp.idDebitoParcelaReceita = tppro.idDebitoParcelaReceita     and tamp.classificacao = :classificacao   )";
        return this.namedParameterJdbcTemplate.query((String)sqlParcelamentoReceita, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoMonetariaDAParcelamentoNrDividaDTO.class));
    }

    @Generated
    public AtualizacaoMonetariaCreditoParcelamentoDACustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

