/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoCreditoCustomRepositoryImpl
implements AtualizacaoCreditoCustomRepository {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private static final String EXERCICIO = "exercicio";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoCreditoCargaExistenteDTO> getCargaExistente(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(EXERCICIO, (Object)exercicio);
        String sql = this.getSqlCargaExistente();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoCargaExistenteDTO.class));
    }

    public List<AtualizacaoCreditoDTO> findAtualizacoes(Long idPessoa, Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoDTO.class));
    }

    private String getSqlCargaExistente() {
        return "select tam.idtipoatualizacaocredito|| '-' ||tlc.NRCREDITO|| '-' ||tlc.NRANOCREDITO|| '-' ||to_char(tam.dtatualizacao, 'yyyy-MM-dd')|| '-' || ca.idtce  AS chave,       tam.idtceatualizamonecred,       tam.idtipoatualizacaocredito,       tam.dtatualizacao,       tlc.nrcredito,       tlc.nranocredito,       ca.idTce as cdControleLeiAto  from tceAtualizaMoneCred tam left join tceAtualizaMonePagamento  tamp   on tamp.idtceatualizamonecred = tam.idtceatualizamonecred left join tceAtualizaMoneCredito    tamc   on tamc.idtceatualizamonecred = tam.idtceatualizamonecred left join tceAtualizaMoneParc    tamparc   on tamparc.idTceAtualizamoneCred = tam.idTceAtualizamoneCred     join tribdebitoparcelareceita  tdpr   on tdpr.iddebitoparcelareceita = coalesce( tamp.iddebitoparcelareceita, tamc.iddebitoparcelareceita, tamparc.iddebitoparcelareceita )     join tribdebito                  td   on tdpr.entidade = td.entidade and tdpr.exercicio = td.exercicio                                           and tdpr.tipocadastro = td.tipocadastro and tdpr.cadastrogeral = td.cadastrogeral                                           and tdpr.guiarecolhimento = td.guiarecolhimento and tdpr.subdivida = td.subdivida  left join tribguiarecolhimento        tg   on tg.entidade =  :entidade                                           and tg.exercicio  = :exercicio                                           and tg.guiarecolhimento = td.guiarecolhimento  left join cgato                       ca   on ca.entidade = tg.entidade and ca.idato = tg.fundamentolegal      join tcedebitolanccredito      tdlc on tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita     join tcelanccredito            tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito where tam.dtatualizacao between :dataInicial and :dataFinal group by tam.idtceatualizamonecred,         tam.idtipoatualizacaocredito,         tam.dtatualizacao,         tlc.nrcredito,         tlc.nranocredito,         ca.idTce";
    }

    @Generated
    public AtualizacaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

