/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastrorural;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoLogradouro;
import br.com.elotech.tributos.domain.Vinculo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ProprietarioItbiDTO {
    private Long pessoa;
    private String tipoPessoa;
    private String cpfCnpj;
    private String nome;
    private Long codigoVinculo;
    private BigDecimal percentual;
    private Boolean coresponsavelPrincipal;
    private Boolean principal;
    private Long idTipoLogradouroAise;
    private Long idLogradouroAise;
    private Long idBairroAise;
    private Long idCidadeAise;
    private String logradouro;
    private String cep;
    private String bairro;
    private String cidade;
    private String numero;
    private String uf;
    private String complemento;
    private String ibge;
    private Long tipoEndereco;

    public Map<String, String> getEndereco() {
        HashMap<String, String> endereco = new HashMap<String, String>();
        endereco.put("logradouro", this.logradouro);
        endereco.put("cep", this.cep);
        endereco.put("bairro", this.bairro);
        endereco.put("cidade", this.cidade);
        endereco.put("numero", this.numero);
        endereco.put("uf", this.uf);
        endereco.put("complemento", this.complemento);
        endereco.put("ibge", this.ibge);
        return endereco;
    }

    public static ProprietarioItbiDTO from(Proprietario proprietario) {
        ProprietarioItbiDTO dto = new ProprietarioItbiDTO();
        Pessoa pessoa = proprietario.getPessoa();
        dto.setPessoa(pessoa.getId());
        dto.setTipoPessoa((String)Optional.ofNullable(pessoa.getTipoPessoa()).map(Enum::name).orElse(null));
        dto.setCpfCnpj(pessoa.getCnpjCpf());
        dto.setNome(pessoa.getNome());
        dto.setCodigoVinculo((Long)Optional.ofNullable(proprietario.getVinculo()).map(Vinculo::getId).orElse(null));
        dto.setPercentual(proprietario.getPercentual());
        dto.setCoresponsavelPrincipal(proprietario.getCoResponsavelPrincipal());
        dto.setPrincipal(proprietario.getPrincipal());
        EnderecoPessoa enderecoPessoa = pessoa.getEnderecoPrincipal();
        if (Objects.nonNull(enderecoPessoa)) {
            Cidade cidade;
            Bairro bairro;
            Logradouro logradouro = enderecoPessoa.getLogradouro();
            if (Objects.nonNull(logradouro)) {
                dto.setIdLogradouroAise(logradouro.getId());
                dto.setIdTipoLogradouroAise((Long)Optional.ofNullable(logradouro.getTipoLogradouro()).map(TipoLogradouro::getId).orElse(null));
                dto.setLogradouro(logradouro.getDescricao());
            }
            if (Objects.nonNull(bairro = enderecoPessoa.getBairro())) {
                dto.setIdBairroAise(bairro.getId());
                dto.setBairro(bairro.getDescricao());
            }
            if (Objects.nonNull(cidade = enderecoPessoa.getCidade())) {
                dto.setIdCidadeAise(cidade.getId());
                dto.setCidade(cidade.getDescricao());
                dto.setUf(cidade.getUnidadeFederacao());
                dto.setIbge((String)Optional.ofNullable(cidade.getCodigoIbge()).map(String::valueOf).orElse(null));
            }
            dto.setCep((String)Optional.ofNullable(enderecoPessoa.getCep()).map(String::valueOf).orElse(null));
            dto.setNumero(enderecoPessoa.getNumero());
            dto.setComplemento(enderecoPessoa.getComplemento());
            dto.setTipoEndereco((Long)Optional.ofNullable(enderecoPessoa.getTipoEndereco()).map(EnderecoTipo::getValue).orElse(null));
        }
        return dto;
    }

    @Generated
    public ProprietarioItbiDTO() {
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Long getCodigoVinculo() {
        return this.codigoVinculo;
    }

    @Generated
    public BigDecimal getPercentual() {
        return this.percentual;
    }

    @Generated
    public Boolean getCoresponsavelPrincipal() {
        return this.coresponsavelPrincipal;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public Long getIdTipoLogradouroAise() {
        return this.idTipoLogradouroAise;
    }

    @Generated
    public Long getIdLogradouroAise() {
        return this.idLogradouroAise;
    }

    @Generated
    public Long getIdBairroAise() {
        return this.idBairroAise;
    }

    @Generated
    public Long getIdCidadeAise() {
        return this.idCidadeAise;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getIbge() {
        return this.ibge;
    }

    @Generated
    public Long getTipoEndereco() {
        return this.tipoEndereco;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoPessoa(String tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCodigoVinculo(Long codigoVinculo) {
        this.codigoVinculo = codigoVinculo;
    }

    @Generated
    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    @Generated
    public void setCoresponsavelPrincipal(Boolean coresponsavelPrincipal) {
        this.coresponsavelPrincipal = coresponsavelPrincipal;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setIdTipoLogradouroAise(Long idTipoLogradouroAise) {
        this.idTipoLogradouroAise = idTipoLogradouroAise;
    }

    @Generated
    public void setIdLogradouroAise(Long idLogradouroAise) {
        this.idLogradouroAise = idLogradouroAise;
    }

    @Generated
    public void setIdBairroAise(Long idBairroAise) {
        this.idBairroAise = idBairroAise;
    }

    @Generated
    public void setIdCidadeAise(Long idCidadeAise) {
        this.idCidadeAise = idCidadeAise;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setIbge(String ibge) {
        this.ibge = ibge;
    }

    @Generated
    public void setTipoEndereco(Long tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProprietarioItbiDTO)) {
            return false;
        }
        ProprietarioItbiDTO other = (ProprietarioItbiDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        String this$tipoPessoa = this.getTipoPessoa();
        String other$tipoPessoa = other.getTipoPessoa();
        if (this$tipoPessoa == null ? other$tipoPessoa != null : !this$tipoPessoa.equals(other$tipoPessoa)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        Long this$codigoVinculo = this.getCodigoVinculo();
        Long other$codigoVinculo = other.getCodigoVinculo();
        if (this$codigoVinculo == null ? other$codigoVinculo != null : !((Object)this$codigoVinculo).equals(other$codigoVinculo)) {
            return false;
        }
        BigDecimal this$percentual = this.getPercentual();
        BigDecimal other$percentual = other.getPercentual();
        if (this$percentual == null ? other$percentual != null : !((Object)this$percentual).equals(other$percentual)) {
            return false;
        }
        Boolean this$coresponsavelPrincipal = this.getCoresponsavelPrincipal();
        Boolean other$coresponsavelPrincipal = other.getCoresponsavelPrincipal();
        if (this$coresponsavelPrincipal == null ? other$coresponsavelPrincipal != null : !((Object)this$coresponsavelPrincipal).equals(other$coresponsavelPrincipal)) {
            return false;
        }
        Boolean this$principal = this.getPrincipal();
        Boolean other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal)) {
            return false;
        }
        Long this$idTipoLogradouroAise = this.getIdTipoLogradouroAise();
        Long other$idTipoLogradouroAise = other.getIdTipoLogradouroAise();
        if (this$idTipoLogradouroAise == null ? other$idTipoLogradouroAise != null : !((Object)this$idTipoLogradouroAise).equals(other$idTipoLogradouroAise)) {
            return false;
        }
        Long this$idLogradouroAise = this.getIdLogradouroAise();
        Long other$idLogradouroAise = other.getIdLogradouroAise();
        if (this$idLogradouroAise == null ? other$idLogradouroAise != null : !((Object)this$idLogradouroAise).equals(other$idLogradouroAise)) {
            return false;
        }
        Long this$idBairroAise = this.getIdBairroAise();
        Long other$idBairroAise = other.getIdBairroAise();
        if (this$idBairroAise == null ? other$idBairroAise != null : !((Object)this$idBairroAise).equals(other$idBairroAise)) {
            return false;
        }
        Long this$idCidadeAise = this.getIdCidadeAise();
        Long other$idCidadeAise = other.getIdCidadeAise();
        if (this$idCidadeAise == null ? other$idCidadeAise != null : !((Object)this$idCidadeAise).equals(other$idCidadeAise)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        if (this$uf == null ? other$uf != null : !this$uf.equals(other$uf)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$ibge = this.getIbge();
        String other$ibge = other.getIbge();
        if (this$ibge == null ? other$ibge != null : !this$ibge.equals(other$ibge)) {
            return false;
        }
        Long this$tipoEndereco = this.getTipoEndereco();
        Long other$tipoEndereco = other.getTipoEndereco();
        return !(this$tipoEndereco == null ? other$tipoEndereco != null : !((Object)this$tipoEndereco).equals(other$tipoEndereco));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProprietarioItbiDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        String $tipoPessoa = this.getTipoPessoa();
        result = result * 59 + ($tipoPessoa == null ? 43 : $tipoPessoa.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        Long $codigoVinculo = this.getCodigoVinculo();
        result = result * 59 + ($codigoVinculo == null ? 43 : ((Object)$codigoVinculo).hashCode());
        BigDecimal $percentual = this.getPercentual();
        result = result * 59 + ($percentual == null ? 43 : ((Object)$percentual).hashCode());
        Boolean $coresponsavelPrincipal = this.getCoresponsavelPrincipal();
        result = result * 59 + ($coresponsavelPrincipal == null ? 43 : ((Object)$coresponsavelPrincipal).hashCode());
        Boolean $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        Long $idTipoLogradouroAise = this.getIdTipoLogradouroAise();
        result = result * 59 + ($idTipoLogradouroAise == null ? 43 : ((Object)$idTipoLogradouroAise).hashCode());
        Long $idLogradouroAise = this.getIdLogradouroAise();
        result = result * 59 + ($idLogradouroAise == null ? 43 : ((Object)$idLogradouroAise).hashCode());
        Long $idBairroAise = this.getIdBairroAise();
        result = result * 59 + ($idBairroAise == null ? 43 : ((Object)$idBairroAise).hashCode());
        Long $idCidadeAise = this.getIdCidadeAise();
        result = result * 59 + ($idCidadeAise == null ? 43 : ((Object)$idCidadeAise).hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $ibge = this.getIbge();
        result = result * 59 + ($ibge == null ? 43 : $ibge.hashCode());
        Long $tipoEndereco = this.getTipoEndereco();
        result = result * 59 + ($tipoEndereco == null ? 43 : ((Object)$tipoEndereco).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProprietarioItbiDTO(pessoa=" + this.getPessoa() + ", tipoPessoa=" + this.getTipoPessoa() + ", cpfCnpj=" + this.getCpfCnpj() + ", nome=" + this.getNome() + ", codigoVinculo=" + this.getCodigoVinculo() + ", percentual=" + this.getPercentual() + ", coresponsavelPrincipal=" + this.getCoresponsavelPrincipal() + ", principal=" + this.getPrincipal() + ", idTipoLogradouroAise=" + this.getIdTipoLogradouroAise() + ", idLogradouroAise=" + this.getIdLogradouroAise() + ", idBairroAise=" + this.getIdBairroAise() + ", idCidadeAise=" + this.getIdCidadeAise() + ", logradouro=" + this.getLogradouro() + ", cep=" + this.getCep() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", numero=" + this.getNumero() + ", uf=" + this.getUf() + ", complemento=" + this.getComplemento() + ", ibge=" + this.getIbge() + ", tipoEndereco=" + this.getTipoEndereco() + ")";
    }
}

