/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.simam;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldoItem;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoImplantacaoSaldo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tcecontroleimplantacao")
public class ImplantacaoSaldo
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s_controleimplantacao_id")
    private Long id;
    private Long entidade;
    private Long exercicio;
    @Length(max=250)
    private @Length(max=250) String usuarioCriacao;
    private LocalDate dataCriacao;
    private LocalDate dataReferencia;
    @Enumerated(value=EnumType.STRING)
    private SituacaoImplantacaoSaldo situacao;
    private LocalDate dataSituacao;
    @ManyToOne
    @JoinColumn(name="IDJOB", referencedColumnName="JOB_EXECUTION_ID")
    private BatchJobExecution batchJobExecution;
    @OneToMany(mappedBy="implantacaoSaldo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImplantacaoSaldoItem> implantacaoSaldoItems = new ArrayList();

    @Generated
    public ImplantacaoSaldo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getUsuarioCriacao() {
        return this.usuarioCriacao;
    }

    @Generated
    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public SituacaoImplantacaoSaldo getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public BatchJobExecution getBatchJobExecution() {
        return this.batchJobExecution;
    }

    @Generated
    public List<ImplantacaoSaldoItem> getImplantacaoSaldoItems() {
        return this.implantacaoSaldoItems;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setUsuarioCriacao(String usuarioCriacao) {
        this.usuarioCriacao = usuarioCriacao;
    }

    @Generated
    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setSituacao(SituacaoImplantacaoSaldo situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setBatchJobExecution(BatchJobExecution batchJobExecution) {
        this.batchJobExecution = batchJobExecution;
    }

    @Generated
    public void setImplantacaoSaldoItems(List<ImplantacaoSaldoItem> implantacaoSaldoItems) {
        this.implantacaoSaldoItems = implantacaoSaldoItems;
    }

    @Generated
    public String toString() {
        return "ImplantacaoSaldo(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", usuarioCriacao=" + this.getUsuarioCriacao() + ", dataCriacao=" + this.getDataCriacao() + ", dataReferencia=" + this.getDataReferencia() + ", situacao=" + this.getSituacao() + ", dataSituacao=" + this.getDataSituacao() + ", batchJobExecution=" + this.getBatchJobExecution() + ", implantacaoSaldoItems=" + this.getImplantacaoSaldoItems() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplantacaoSaldo)) {
            return false;
        }
        ImplantacaoSaldo other = (ImplantacaoSaldo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImplantacaoSaldo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

