/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CategoriaMobiliario;
import br.com.elotech.tributos.domain.ClassificacaoMobiliario;
import br.com.elotech.tributos.domain.NaturezaJuridica;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.PessoaMobiliario;
import br.com.elotech.tributos.domain.RamoAtividade;
import br.com.elotech.tributos.domain.RepresentanteLegal;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.camposdinamicos.DynamicValidation;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaMobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.mobiliario.BoletimMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioAtividade;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCnae;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioHorarioEspecial;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioListaServico;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioProfissional;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioRegimeFiscal;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioServico;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioSituacao;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioVeiculo;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.dto.CadastroMobiliarioAlteracaoCadastralDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import br.com.elotech.tributos.util.ListUtils;
import br.com.elotech.tributos.util.UsuarioUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.builtin.BooleanBridge;

@Entity
@Indexed
@Table(name="TRIBCADASTROMOBILIARIO")
@PrimaryKeyJoinColumn(name="TRIBCADASTROGERAL_IDKEY")
@DynamicInsert
@DynamicUpdate
@Audited
public class CadastroMobiliario
extends CadastroGeral {
    @ManyToOne
    @JoinColumn
    @NotAudited
    private Pessoa pessoaEmpresa;
    @Column(length=20)
    @Caption(value="Registro Federal")
    private String registroFederal;
    @Column(length=20)
    @Caption(value="Junta Comercial")
    private String juntaComercial;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Inscri\u00e7\u00e3o Estadual")
    private Boolean inscricaoEstadual = Boolean.FALSE;
    @Column(length=10)
    @Caption(value="N\u00famero Registro")
    private String numeroRegistro;
    @Column(length=60)
    @Caption(value="Gerente")
    private String gerente;
    @Field(analyze=Analyze.NO)
    @FieldBridge(impl=BooleanBridge.class)
    @Facet(encoding=FacetEncodingType.STRING)
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Micro Empresa")
    @DynamicValidation(label="Micro Empresa")
    private Boolean microEmpresa = Boolean.FALSE;
    @Caption(value="\u00c1rea Utilizada")
    private BigDecimal areaUtilizada = BigDecimal.ZERO;
    @Caption(value="Data Abertura")
    private LocalDate dataAbertura;
    @Caption(value="Data Validade \u00c1lvara")
    private LocalDate dataValidadeAlvara;
    @Caption(value="Data Encerramento")
    private LocalDate dataEncerramento;
    @Caption(value="Data \u00daltima Fiscaliza\u00e7\u00e3o")
    private LocalDate dataUltimaFiscalizacao;
    @ManyToOne
    @Caption(value="Tipo de Pessoa")
    @DiffRevisionIgnoreProperties(value={"id"})
    private PessoaMobiliario pessoaMobiliario;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Categoria")
    @DiffRevisionIgnoreProperties(value={"id"})
    private CategoriaMobiliario categoriaMobiliario;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private ClassificacaoMobiliario classificacaoMobiliario;
    @Caption(value="Data Alvar\u00e1")
    private LocalDate dataAlvara;
    @Field(analyze=Analyze.NO)
    @FieldBridge(impl=BooleanBridge.class)
    @Facet(encoding=FacetEncodingType.STRING)
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Super Simples")
    @DynamicValidation(label="Super Simples")
    private Boolean superSimples = Boolean.FALSE;
    @Caption(value="Super Simples Anexo")
    private Long superSimplesAnexo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipoCadastroImobiliario", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeralImobiliario", referencedColumnName="cadastroGeral")})
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Cadastro Imobili\u00e1rio")
    @DiffRevisionIgnoreProperties(value={"pessoa", "numero", "complemento", "cidade", "logradouro", "bairro", "cep", "exclusaoLogica", "englobado", "suspensoEmissao", "correspondenciaLocal", "dataInclusao", "dataAlteracao", "debitoAutomatico", "enderecoEntregaCarneAnual", "enderecoCorrespondencia", "numeroCorrespondencia", "cidadeCorrespondencia", "ufCorrespondencia", "usuario", "visivelNFSE", "proprietarios", "regimeFiscalPeriodo", "observacoes", "respostasAvulso", "inscricaoCadastral", "distritoLocalizacao", "setorLocalizacao", "loteLocalizacao", "unidadeLocalizacao", "areaLote", "areaTotalConstruida", "limitaCercaMuro", "imovelProprio", "caucionado", "areaConstruida", "areaUtilLote", "areaPrivativa", "areaComum", "tipoImovel", "segundoSul", "segundoOeste", "tipoLote", "areaTotalNaoLancada", "situacoes", "areasVerde", "avaliacoes", "desapropriacoes", "profundidades", "segmentos", "testadas", "testadasGenericas", "respostaTerrenos", "geminadas", "cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioAreasVerde", "cadastroImobiliarioSituacoes", "cadastroImobiliarioSegmentos", "distritoInscricaoCadastral", "setorInscricaoCadastral", "condominio", "loteamento", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas"})
    private CadastroImobiliario cadastroImobiliario;
    @Caption(value="Exerc\u00edcio Alvar\u00e1")
    private Long exercicioAlvara;
    @Caption(value="Entidade")
    private Long entidade;
    @Column(name="exercProcessoAbertura")
    @Caption(value="Exerc\u00edcio Processo Abertura")
    private Long exercicioProcessoAbertura;
    @Caption(value="C\u00f3digo Processo Abertura")
    private Long idProcessoAbertura;
    @Column(name="exercProcessoEncerramento")
    @Caption(value="Exerc\u00edcio Processo Encerramento")
    private Long exercicioProcessoEncerramento;
    @Caption(value="C\u00f3digo Processo Encerramento")
    private Long idProcessoEncerramento;
    @Caption(value="N\u00famero Alvar\u00e1")
    private Long numeroAlvara;
    @Caption(value="Quantidade de Funcion\u00e1rios")
    private Long qtdeFuncionario;
    @NotAudited
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="2", referencedColumnName="tipoCadastro")), @JoinColumnOrFormula(column=@JoinColumn(name="cmcresponsavel", referencedColumnName="cadastroGeral"))})
    @Caption(value="CMC Respons\u00e1vel")
    @DiffRevisionIgnoreProperties(value={"cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioAreasVerde", "cadastroImobiliarioSituacoes", "cadastroImobiliarioSegmentos", "distritoInscricaoCadastral", "setorInscricaoCadastral", "condominio", "loteamento", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas"})
    private CadastroGeral cmcResponsavel;
    @Column(length=4000)
    @Caption(value="Observa\u00e7\u00e3o alvar\u00e1")
    private String observacaoAlvara;
    @Caption(value="\u00c1rea Publicidade 1")
    private BigDecimal areaPublicidade1 = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Publicidade 2")
    private BigDecimal areaPublicidade2 = BigDecimal.ZERO;
    @Caption(value="Data Auditoria In\u00edcio")
    private LocalDate dataAuditoriaInicio;
    @Caption(value="Data Auditoria Fim")
    private LocalDate dataAuditoriaFim;
    @Caption(value="Data Homologa\u00e7\u00e3o")
    private LocalDate dataHomologacao;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"id"})
    private RamoAtividade ramoAtividade;
    @Caption(value="\u00c1rea Bombeiro")
    private BigDecimal areaBombeiro = BigDecimal.ZERO;
    @DiffRevisionIgnore
    private Long idNotificacaoFiscalizacao;
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    @Column(length=3000)
    @Caption(value="Atividade Principal")
    private String atividadePrincipal;
    @Column(length=20)
    @Caption(value="Telefone")
    private String telefone;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Dispensa Nota Fiscal")
    private Boolean dispensaNotaFiscal = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Substitui\u00e7\u00e3o Tribut\u00e1ria")
    private Boolean substituicaoTributaria = Boolean.FALSE;
    @Caption(value="Laudo")
    private Long laudo;
    @Caption(value="Exerc\u00edcio Laudo")
    private Long exercicioLaudo;
    @ManyToOne
    @JoinColumn(name="idNaturezaJuridica", referencedColumnName="idNaturezaJuridica")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DynamicValidation(label="Natureza Jur\u00eddica")
    @Caption(value="Natureza Jur\u00eddica")
    @DiffRevisionIgnoreProperties(value={"id", "pessoaMobiliario"})
    private NaturezaJuridica naturezaJuridica;
    @DiffRevisionIgnore
    private Long idCadastroMobiliarioISS;
    @Transient
    private Long solicitacao;
    @Transient
    private Long exercicioSolicitacao;
    @Caption(value="\u00c1rea P\u00e1tio")
    private BigDecimal areaPatio = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Contru\u00edda")
    private BigDecimal areaConstruida = BigDecimal.ZERO;
    @Caption(value="Setor Vistoria")
    private Long setorVistoria;
    @Caption(value="Lota\u00e7\u00e3o Vistoria")
    private Long lotacaoVistoria;
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Situa\u00e7\u00f5es")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroMobiliarioSituacao> cadastroMobiliarioSituacoes = new ArrayList();
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Atividades")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroMobiliarioAtividade> cadastroMobiliarioAtividades = new ArrayList();
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Cnaes")
    @DiffRevisionIgnoreProperties(value={"id"})
    private List<CadastroMobiliarioCnae> cadastroMobiliarioCnaes = new ArrayList();
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Hor\u00e1rios Especiais")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroMobiliarioHorarioEspecial> cadastroMobiliarioHorariosEspeciais = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Listas Servi\u00e7o")
    @NotAudited
    private final List<CadastroMobiliarioListaServico> cadastroMobiliarioListasServicos = new ArrayList();
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Servi\u00e7os")
    @NotAudited
    private final List<CadastroMobiliarioServico> cadastroMobiliarioServicos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Ve\u00edculos")
    @NotAudited
    private final List<CadastroMobiliarioVeiculo> cadastroMobiliarioVeiculos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Regimes Fiscais")
    @AuditJoinTable(name="TRIB_MOBREGIMEFISCAL_MOB_AUD")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroMobiliarioRegimeFiscal> cadastroMobiliarioRegimesFiscais = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Boletim Imobili\u00e1rio")
    @NotAudited
    private final List<BoletimMobiliario> boletinsMobiliario = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Profissionais")
    @NotAudited
    private final List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionais = new ArrayList();
    @IndexedEmbedded
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Contratos Social")
    @DiffRevisionIgnoreProperties(value={"id"})
    @JsonIgnoreProperties(value={"cadastroMobiliario"})
    private final List<ContratoSocial> contratosSocial = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroMobiliario")
    @Caption(value="Boletim Mobiliario")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<RespostaMobiliario> respostasMobiliarios = new ArrayList();
    @OneToMany(mappedBy="cadastroMobiliario", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Caption(value="Representante Legal")
    @DiffRevisionIgnoreProperties(value={"id"})
    @JsonIgnoreProperties(value={"cadastroMobiliario"})
    @NotAudited
    private final List<RepresentanteLegal> representantesLegais = new ArrayList();

    @Field(analyze=Analyze.NO)
    @Facet
    @JsonIgnore
    public String getPessoaMobiliarioDescricao() {
        return Optional.ofNullable(this.getPessoaMobiliario()).map(PessoaMobiliario::getDescricao).orElse("");
    }

    @Field(analyze=Analyze.NO)
    @Facet
    @JsonIgnore
    public String getCategoriaMobiliarioDescricao() {
        return Optional.ofNullable(this.getCategoriaMobiliario()).map(CategoriaMobiliario::getDescricao).orElse("");
    }

    @Field(analyze=Analyze.NO)
    @Facet
    @JsonIgnore
    public String getClassificacaoMobiliarioDescricao() {
        return Optional.ofNullable(this.getClassificacaoMobiliario()).map(ClassificacaoMobiliario::getDescricao).orElse("");
    }

    @DiffRevisionIgnore
    public SituacaoMobiliario getSituacaoAtual() {
        return this.cadastroMobiliarioSituacoes.stream().filter(CadastroMobiliarioSituacao::getAtual).map(CadastroMobiliarioSituacao::getSituacaoMobiliario).findFirst().orElse(null);
    }

    @DiffRevisionIgnore
    @JsonIgnore
    @Field(name="situacaoAtual_sort", analyze=Analyze.NO)
    @SortableField(forField="situacaoAtual_sort")
    public String getSituacaoAtual_sort() {
        return Optional.ofNullable(this.getSituacaoAtual()).map(SituacaoMobiliario::getDescricao).orElse("");
    }

    @DiffRevisionIgnore
    public Long getLastSequenciaSituacao() {
        return this.cadastroMobiliarioSituacoes.stream().filter(situacao -> Objects.nonNull(situacao.getSequencia())).mapToLong(CadastroMobiliarioSituacao::getSequencia).max().orElse(0L);
    }

    public CadastroMobiliario set(CadastroMobiliarioAlteracaoCadastralDTO dto) {
        Optional.ofNullable(TipoCadastro.fromValue((Long)dto.getTipoCadastro())).ifPresent(arg_0 -> ((CadastroMobiliario)this).setTipoCadastro(arg_0));
        Optional.ofNullable(dto.getCadastroGeral()).ifPresent(arg_0 -> ((CadastroMobiliario)this).setCadastroGeral(arg_0));
        Optional.ofNullable(dto.getDataAbertura()).ifPresent(arg_0 -> this.setDataAbertura(arg_0));
        Optional.ofNullable(dto.getDataEncerramento()).ifPresent(arg_0 -> this.setDataEncerramento(arg_0));
        Optional.ofNullable(dto.getCmcResponsavel()).ifPresent(responsavelId -> {
            CadastroMobiliario cadastroMobiliario = new CadastroMobiliario();
            cadastroMobiliario.setId(responsavelId);
            this.setCmcResponsavel((CadastroGeral)cadastroMobiliario);
        });
        Optional.ofNullable(dto.getDataValidadeAlvara()).ifPresent(arg_0 -> this.setDataValidadeAlvara(arg_0));
        Optional.ofNullable(dto.getDataUltimaFiscalizacao()).ifPresent(arg_0 -> this.setDataUltimaFiscalizacao(arg_0));
        Optional.ofNullable(dto.getAreaUtilizada()).ifPresent(arg_0 -> this.setAreaUtilizada(arg_0));
        Optional.ofNullable(dto.getAreaConstruida()).ifPresent(arg_0 -> this.setAreaConstruida(arg_0));
        Optional.ofNullable(dto.getExercicioAlvara()).ifPresent(arg_0 -> this.setExercicioAlvara(arg_0));
        Optional.ofNullable(dto.getExercicioProcessoAbertura()).ifPresent(arg_0 -> this.setExercicioProcessoAbertura(arg_0));
        Optional.ofNullable(dto.getExercicioProcessoEncerramento()).ifPresent(arg_0 -> this.setExercicioProcessoEncerramento(arg_0));
        Optional.ofNullable(dto.getNumeroAlvara()).ifPresent(arg_0 -> this.setNumeroAlvara(arg_0));
        Optional.ofNullable(dto.getNumeroRegistro()).ifPresent(arg_0 -> this.setNumeroRegistro(arg_0));
        return this;
    }

    public CadastroMobiliario merge(CadastroMobiliario cadastroMobiliarioToMerge) {
        this.setUsuario(UsuarioUtils.getUsuarioAise());
        this.setDataAlteracao(LocalDate.now());
        this.setPessoa(cadastroMobiliarioToMerge.getPessoa());
        this.setNumeroRegistro(cadastroMobiliarioToMerge.getNumeroRegistro());
        this.setAtividadePrincipal(cadastroMobiliarioToMerge.getAtividadePrincipal());
        this.setCadastroImobiliario(cadastroMobiliarioToMerge.getCadastroImobiliario());
        this.setCidade(cadastroMobiliarioToMerge.getCidade());
        this.setLogradouro(cadastroMobiliarioToMerge.getLogradouro());
        this.setNumero(cadastroMobiliarioToMerge.getNumero());
        this.setCep(cadastroMobiliarioToMerge.getCep());
        this.setBairro(cadastroMobiliarioToMerge.getBairro());
        this.setComplemento(cadastroMobiliarioToMerge.getComplemento());
        this.setTelefone(cadastroMobiliarioToMerge.getTelefone());
        this.setPessoaMobiliario(cadastroMobiliarioToMerge.getPessoaMobiliario());
        this.setExercicioAlvara(cadastroMobiliarioToMerge.getExercicioAlvara());
        this.setNumeroAlvara(cadastroMobiliarioToMerge.getNumeroAlvara());
        this.setDataAlvara(cadastroMobiliarioToMerge.getDataAlvara());
        this.setDataValidadeAlvara(cadastroMobiliarioToMerge.getDataValidadeAlvara());
        this.setDataAbertura(cadastroMobiliarioToMerge.getDataAbertura());
        this.setExercicioProcessoAbertura(cadastroMobiliarioToMerge.getExercicioProcessoAbertura());
        this.setIdProcessoAbertura(cadastroMobiliarioToMerge.getIdProcessoAbertura());
        this.setPessoaMobiliario(cadastroMobiliarioToMerge.getPessoaMobiliario());
        this.setCmcResponsavel(cadastroMobiliarioToMerge.getCmcResponsavel());
        this.setObservacaoAlvara(cadastroMobiliarioToMerge.getObservacaoAlvara());
        this.setNaturezaJuridica(cadastroMobiliarioToMerge.getNaturezaJuridica());
        this.setClassificacaoMobiliario(cadastroMobiliarioToMerge.getClassificacaoMobiliario());
        this.setCategoriaMobiliario(cadastroMobiliarioToMerge.getCategoriaMobiliario());
        this.setMicroEmpresa(cadastroMobiliarioToMerge.getMicroEmpresa());
        this.setDispensaNotaFiscal(cadastroMobiliarioToMerge.getDispensaNotaFiscal());
        this.setSubstituicaoTributaria(cadastroMobiliarioToMerge.getSubstituicaoTributaria());
        this.setVisivelNfse(cadastroMobiliarioToMerge.getVisivelNfse());
        this.setDataAuditoriaInicio(cadastroMobiliarioToMerge.getDataAuditoriaInicio());
        this.setDataAuditoriaFim(cadastroMobiliarioToMerge.getDataAuditoriaFim());
        this.setDataHomologacao(cadastroMobiliarioToMerge.getDataHomologacao());
        this.setAreaUtilizada(cadastroMobiliarioToMerge.getAreaUtilizada());
        this.setAreaConstruida(cadastroMobiliarioToMerge.getAreaConstruida());
        this.setAreaBombeiro(cadastroMobiliarioToMerge.getAreaBombeiro());
        this.setAreaPublicidade1(cadastroMobiliarioToMerge.getAreaPublicidade1());
        this.setAreaPublicidade2(cadastroMobiliarioToMerge.getAreaPublicidade2());
        this.setAreaPatio(cadastroMobiliarioToMerge.getAreaPatio());
        this.setQtdeFuncionario(cadastroMobiliarioToMerge.getQtdeFuncionario());
        this.mergeCadastroMobiliarioAtividade(cadastroMobiliarioToMerge);
        this.mergeCadastroMobiliarioHorarioEspecial(cadastroMobiliarioToMerge);
        this.mergeCadastroMobiliarioCnae(cadastroMobiliarioToMerge);
        this.mergeRespostasMobiliario(cadastroMobiliarioToMerge);
        this.mergeRegimeFiscalPeriodo(cadastroMobiliarioToMerge.getRegimeFiscalPeriodo());
        this.addObservacoes(cadastroMobiliarioToMerge.getObservacoes());
        this.setTipoEnderecoCorrespondencia(cadastroMobiliarioToMerge.getTipoEnderecoCorrespondencia());
        this.setCepCorrespondencia(cadastroMobiliarioToMerge.getCepCorrespondencia());
        this.setEnderecoCorrespondencia(cadastroMobiliarioToMerge.getEnderecoCorrespondencia());
        this.setNumeroCorrespondencia(cadastroMobiliarioToMerge.getNumeroCorrespondencia());
        this.setComplementoCorrespondencia(cadastroMobiliarioToMerge.getComplementoCorrespondencia());
        this.setBairroCorrespondencia(cadastroMobiliarioToMerge.getBairroCorrespondencia());
        this.setCidadeUfCorrespondencia(cadastroMobiliarioToMerge.getCidadeUfCorrespondencia());
        this.setUfCorrespondencia(cadastroMobiliarioToMerge.getUfCorrespondencia());
        return this;
    }

    private void mergeCadastroMobiliarioAtividade(CadastroMobiliario cadastroMobiliario) {
        List merged = ListUtils.merge((List)this.getCadastroMobiliarioAtividades(), (List)cadastroMobiliario.getCadastroMobiliarioAtividades(), cadastroMobiliarioAtividade -> cadastroMobiliarioAtividade.getAtividade().getId(), CadastroMobiliarioAtividade::merge);
        merged.forEach(atividade -> atividade.setCadastroMobiliario(cadastroMobiliario));
        this.getCadastroMobiliarioAtividades().clear();
        this.getCadastroMobiliarioAtividades().addAll(merged);
    }

    public void mergeCadastroMobiliarioHorarioEspecial(CadastroMobiliario cadastroMobiliario) {
        List merged = ListUtils.merge((List)this.getCadastroMobiliarioHorariosEspeciais(), (List)cadastroMobiliario.getCadastroMobiliarioHorariosEspeciais(), CadastroMobiliarioHorarioEspecial::getHorarioEspecial, CadastroMobiliarioHorarioEspecial::merge);
        merged.forEach(horarioEspecial -> horarioEspecial.setCadastroMobiliario(cadastroMobiliario));
        this.getCadastroMobiliarioHorariosEspeciais().clear();
        this.getCadastroMobiliarioHorariosEspeciais().addAll(merged);
    }

    public void mergeCadastroMobiliarioCnae(CadastroMobiliario cadastroMobiliario) {
        List merged = ListUtils.merge((List)this.getCadastroMobiliarioCnaes(), (List)cadastroMobiliario.getCadastroMobiliarioCnaes(), cadastroMobiliarioCnae -> cadastroMobiliarioCnae.getCnae().getId(), CadastroMobiliarioCnae::merge);
        merged.forEach(cnae -> cnae.setCadastroMobiliario(cadastroMobiliario));
        this.getCadastroMobiliarioCnaes().clear();
        this.getCadastroMobiliarioCnaes().addAll(merged);
    }

    private void mergeRespostasMobiliario(CadastroMobiliario cadastroMobiliario) {
        List merged = ListUtils.merge((List)this.getRespostasMobiliarios(), (List)cadastroMobiliario.getRespostasMobiliarios(), Resposta::getId, RespostaMobiliario::merge);
        merged.forEach(resposta -> resposta.setCadastroMobiliario(cadastroMobiliario));
        this.getRespostasMobiliarios().clear();
        this.getRespostasMobiliarios().addAll(merged);
    }

    public Boolean possuiServicoNoExercicio(Long exercicio) {
        return this.getCadastroMobiliarioServicos().stream().anyMatch(servico -> servico.getServico().getExercicio().equals(exercicio));
    }

    public EnderecoCadastroGeralDTO toEnderecoCadastroGeralDTO() {
        EnderecoCadastroGeralDTO dto = super.toEnderecoCadastroGeralDTO();
        Optional.ofNullable(this.getSituacaoAtual()).map(SituacaoMobiliario::getDescricao).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setSituacaoAtual(arg_0));
        return dto;
    }

    @Generated
    public CadastroMobiliario() {
    }

    @Generated
    public Pessoa getPessoaEmpresa() {
        return this.pessoaEmpresa;
    }

    @Generated
    public String getRegistroFederal() {
        return this.registroFederal;
    }

    @Generated
    public String getJuntaComercial() {
        return this.juntaComercial;
    }

    @Generated
    public Boolean getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    @Generated
    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    @Generated
    public String getGerente() {
        return this.gerente;
    }

    @Generated
    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    @Generated
    public BigDecimal getAreaUtilizada() {
        return this.areaUtilizada;
    }

    @Generated
    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public LocalDate getDataValidadeAlvara() {
        return this.dataValidadeAlvara;
    }

    @Generated
    public LocalDate getDataEncerramento() {
        return this.dataEncerramento;
    }

    @Generated
    public LocalDate getDataUltimaFiscalizacao() {
        return this.dataUltimaFiscalizacao;
    }

    @Generated
    public PessoaMobiliario getPessoaMobiliario() {
        return this.pessoaMobiliario;
    }

    @Generated
    public CategoriaMobiliario getCategoriaMobiliario() {
        return this.categoriaMobiliario;
    }

    @Generated
    public ClassificacaoMobiliario getClassificacaoMobiliario() {
        return this.classificacaoMobiliario;
    }

    @Generated
    public LocalDate getDataAlvara() {
        return this.dataAlvara;
    }

    @Generated
    public Boolean getSuperSimples() {
        return this.superSimples;
    }

    @Generated
    public Long getSuperSimplesAnexo() {
        return this.superSimplesAnexo;
    }

    @Generated
    public CadastroImobiliario getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    @Generated
    public Long getExercicioAlvara() {
        return this.exercicioAlvara;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicioProcessoAbertura() {
        return this.exercicioProcessoAbertura;
    }

    @Generated
    public Long getIdProcessoAbertura() {
        return this.idProcessoAbertura;
    }

    @Generated
    public Long getExercicioProcessoEncerramento() {
        return this.exercicioProcessoEncerramento;
    }

    @Generated
    public Long getIdProcessoEncerramento() {
        return this.idProcessoEncerramento;
    }

    @Generated
    public Long getNumeroAlvara() {
        return this.numeroAlvara;
    }

    @Generated
    public Long getQtdeFuncionario() {
        return this.qtdeFuncionario;
    }

    @Generated
    public CadastroGeral getCmcResponsavel() {
        return this.cmcResponsavel;
    }

    @Generated
    public String getObservacaoAlvara() {
        return this.observacaoAlvara;
    }

    @Generated
    public BigDecimal getAreaPublicidade1() {
        return this.areaPublicidade1;
    }

    @Generated
    public BigDecimal getAreaPublicidade2() {
        return this.areaPublicidade2;
    }

    @Generated
    public LocalDate getDataAuditoriaInicio() {
        return this.dataAuditoriaInicio;
    }

    @Generated
    public LocalDate getDataAuditoriaFim() {
        return this.dataAuditoriaFim;
    }

    @Generated
    public LocalDate getDataHomologacao() {
        return this.dataHomologacao;
    }

    @Generated
    public RamoAtividade getRamoAtividade() {
        return this.ramoAtividade;
    }

    @Generated
    public BigDecimal getAreaBombeiro() {
        return this.areaBombeiro;
    }

    @Generated
    public Long getIdNotificacaoFiscalizacao() {
        return this.idNotificacaoFiscalizacao;
    }

    @Generated
    public String getAtividadePrincipal() {
        return this.atividadePrincipal;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public Boolean getDispensaNotaFiscal() {
        return this.dispensaNotaFiscal;
    }

    @Generated
    public Boolean getSubstituicaoTributaria() {
        return this.substituicaoTributaria;
    }

    @Generated
    public Long getLaudo() {
        return this.laudo;
    }

    @Generated
    public Long getExercicioLaudo() {
        return this.exercicioLaudo;
    }

    @Generated
    public NaturezaJuridica getNaturezaJuridica() {
        return this.naturezaJuridica;
    }

    @Generated
    public Long getIdCadastroMobiliarioISS() {
        return this.idCadastroMobiliarioISS;
    }

    @Generated
    public Long getSolicitacao() {
        return this.solicitacao;
    }

    @Generated
    public Long getExercicioSolicitacao() {
        return this.exercicioSolicitacao;
    }

    @Generated
    public BigDecimal getAreaPatio() {
        return this.areaPatio;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public Long getSetorVistoria() {
        return this.setorVistoria;
    }

    @Generated
    public Long getLotacaoVistoria() {
        return this.lotacaoVistoria;
    }

    @Generated
    public List<CadastroMobiliarioSituacao> getCadastroMobiliarioSituacoes() {
        return this.cadastroMobiliarioSituacoes;
    }

    @Generated
    public List<CadastroMobiliarioAtividade> getCadastroMobiliarioAtividades() {
        return this.cadastroMobiliarioAtividades;
    }

    @Generated
    public List<CadastroMobiliarioCnae> getCadastroMobiliarioCnaes() {
        return this.cadastroMobiliarioCnaes;
    }

    @Generated
    public List<CadastroMobiliarioHorarioEspecial> getCadastroMobiliarioHorariosEspeciais() {
        return this.cadastroMobiliarioHorariosEspeciais;
    }

    @Generated
    public List<CadastroMobiliarioListaServico> getCadastroMobiliarioListasServicos() {
        return this.cadastroMobiliarioListasServicos;
    }

    @Generated
    public List<CadastroMobiliarioServico> getCadastroMobiliarioServicos() {
        return this.cadastroMobiliarioServicos;
    }

    @Generated
    public List<CadastroMobiliarioVeiculo> getCadastroMobiliarioVeiculos() {
        return this.cadastroMobiliarioVeiculos;
    }

    @Generated
    public List<CadastroMobiliarioRegimeFiscal> getCadastroMobiliarioRegimesFiscais() {
        return this.cadastroMobiliarioRegimesFiscais;
    }

    @Generated
    public List<BoletimMobiliario> getBoletinsMobiliario() {
        return this.boletinsMobiliario;
    }

    @Generated
    public List<CadastroMobiliarioProfissional> getCadastroMobiliarioProfissionais() {
        return this.cadastroMobiliarioProfissionais;
    }

    @Generated
    public List<ContratoSocial> getContratosSocial() {
        return this.contratosSocial;
    }

    @Generated
    public List<RespostaMobiliario> getRespostasMobiliarios() {
        return this.respostasMobiliarios;
    }

    @Generated
    public List<RepresentanteLegal> getRepresentantesLegais() {
        return this.representantesLegais;
    }

    @Generated
    public void setPessoaEmpresa(Pessoa pessoaEmpresa) {
        this.pessoaEmpresa = pessoaEmpresa;
    }

    @Generated
    public void setRegistroFederal(String registroFederal) {
        this.registroFederal = registroFederal;
    }

    @Generated
    public void setJuntaComercial(String juntaComercial) {
        this.juntaComercial = juntaComercial;
    }

    @Generated
    public void setInscricaoEstadual(Boolean inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    @Generated
    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    @Generated
    public void setGerente(String gerente) {
        this.gerente = gerente;
    }

    @Generated
    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    @Generated
    public void setAreaUtilizada(BigDecimal areaUtilizada) {
        this.areaUtilizada = areaUtilizada;
    }

    @Generated
    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setDataValidadeAlvara(LocalDate dataValidadeAlvara) {
        this.dataValidadeAlvara = dataValidadeAlvara;
    }

    @Generated
    public void setDataEncerramento(LocalDate dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    @Generated
    public void setDataUltimaFiscalizacao(LocalDate dataUltimaFiscalizacao) {
        this.dataUltimaFiscalizacao = dataUltimaFiscalizacao;
    }

    @Generated
    public void setPessoaMobiliario(PessoaMobiliario pessoaMobiliario) {
        this.pessoaMobiliario = pessoaMobiliario;
    }

    @Generated
    public void setCategoriaMobiliario(CategoriaMobiliario categoriaMobiliario) {
        this.categoriaMobiliario = categoriaMobiliario;
    }

    @Generated
    public void setClassificacaoMobiliario(ClassificacaoMobiliario classificacaoMobiliario) {
        this.classificacaoMobiliario = classificacaoMobiliario;
    }

    @Generated
    public void setDataAlvara(LocalDate dataAlvara) {
        this.dataAlvara = dataAlvara;
    }

    @Generated
    public void setSuperSimples(Boolean superSimples) {
        this.superSimples = superSimples;
    }

    @Generated
    public void setSuperSimplesAnexo(Long superSimplesAnexo) {
        this.superSimplesAnexo = superSimplesAnexo;
    }

    @Generated
    public void setCadastroImobiliario(CadastroImobiliario cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    @Generated
    public void setExercicioAlvara(Long exercicioAlvara) {
        this.exercicioAlvara = exercicioAlvara;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicioProcessoAbertura(Long exercicioProcessoAbertura) {
        this.exercicioProcessoAbertura = exercicioProcessoAbertura;
    }

    @Generated
    public void setIdProcessoAbertura(Long idProcessoAbertura) {
        this.idProcessoAbertura = idProcessoAbertura;
    }

    @Generated
    public void setExercicioProcessoEncerramento(Long exercicioProcessoEncerramento) {
        this.exercicioProcessoEncerramento = exercicioProcessoEncerramento;
    }

    @Generated
    public void setIdProcessoEncerramento(Long idProcessoEncerramento) {
        this.idProcessoEncerramento = idProcessoEncerramento;
    }

    @Generated
    public void setNumeroAlvara(Long numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    @Generated
    public void setQtdeFuncionario(Long qtdeFuncionario) {
        this.qtdeFuncionario = qtdeFuncionario;
    }

    @Generated
    public void setCmcResponsavel(CadastroGeral cmcResponsavel) {
        this.cmcResponsavel = cmcResponsavel;
    }

    @Generated
    public void setObservacaoAlvara(String observacaoAlvara) {
        this.observacaoAlvara = observacaoAlvara;
    }

    @Generated
    public void setAreaPublicidade1(BigDecimal areaPublicidade1) {
        this.areaPublicidade1 = areaPublicidade1;
    }

    @Generated
    public void setAreaPublicidade2(BigDecimal areaPublicidade2) {
        this.areaPublicidade2 = areaPublicidade2;
    }

    @Generated
    public void setDataAuditoriaInicio(LocalDate dataAuditoriaInicio) {
        this.dataAuditoriaInicio = dataAuditoriaInicio;
    }

    @Generated
    public void setDataAuditoriaFim(LocalDate dataAuditoriaFim) {
        this.dataAuditoriaFim = dataAuditoriaFim;
    }

    @Generated
    public void setDataHomologacao(LocalDate dataHomologacao) {
        this.dataHomologacao = dataHomologacao;
    }

    @Generated
    public void setRamoAtividade(RamoAtividade ramoAtividade) {
        this.ramoAtividade = ramoAtividade;
    }

    @Generated
    public void setAreaBombeiro(BigDecimal areaBombeiro) {
        this.areaBombeiro = areaBombeiro;
    }

    @Generated
    public void setIdNotificacaoFiscalizacao(Long idNotificacaoFiscalizacao) {
        this.idNotificacaoFiscalizacao = idNotificacaoFiscalizacao;
    }

    @Generated
    public void setAtividadePrincipal(String atividadePrincipal) {
        this.atividadePrincipal = atividadePrincipal;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public void setDispensaNotaFiscal(Boolean dispensaNotaFiscal) {
        this.dispensaNotaFiscal = dispensaNotaFiscal;
    }

    @Generated
    public void setSubstituicaoTributaria(Boolean substituicaoTributaria) {
        this.substituicaoTributaria = substituicaoTributaria;
    }

    @Generated
    public void setLaudo(Long laudo) {
        this.laudo = laudo;
    }

    @Generated
    public void setExercicioLaudo(Long exercicioLaudo) {
        this.exercicioLaudo = exercicioLaudo;
    }

    @Generated
    public void setNaturezaJuridica(NaturezaJuridica naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica;
    }

    @Generated
    public void setIdCadastroMobiliarioISS(Long idCadastroMobiliarioISS) {
        this.idCadastroMobiliarioISS = idCadastroMobiliarioISS;
    }

    @Generated
    public void setSolicitacao(Long solicitacao) {
        this.solicitacao = solicitacao;
    }

    @Generated
    public void setExercicioSolicitacao(Long exercicioSolicitacao) {
        this.exercicioSolicitacao = exercicioSolicitacao;
    }

    @Generated
    public void setAreaPatio(BigDecimal areaPatio) {
        this.areaPatio = areaPatio;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setSetorVistoria(Long setorVistoria) {
        this.setorVistoria = setorVistoria;
    }

    @Generated
    public void setLotacaoVistoria(Long lotacaoVistoria) {
        this.lotacaoVistoria = lotacaoVistoria;
    }

    @Generated
    public void setCadastroMobiliarioCnaes(List<CadastroMobiliarioCnae> cadastroMobiliarioCnaes) {
        this.cadastroMobiliarioCnaes = cadastroMobiliarioCnaes;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliario(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliario)) {
            return false;
        }
        CadastroMobiliario other = (CadastroMobiliario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliario;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

