/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoAto;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="CGATO")
public class Ato
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="entidade")
    @NotNull
    @JsonIgnoreProperties(value={"brasao"})
    private Entidade entidade;
    @EloSequence
    private Long idAto;
    @ManyToOne
    @JoinColumn
    private TipoAto tipoAto;
    @Positive
    private Long numeroAto;
    @Positive
    private Long anoAto;
    @Length(max=1)
    private @Length(max=1) String esfera;
    @Length(max=100)
    private @Length(max=100) String descricao;
    private LocalDate dataAto;
    private LocalDate dataInicioVigencia;
    private LocalDate dataFimVigencia;
    private String modulo;
    private Long idTce;

    @Generated
    public Ato() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getIdAto() {
        return this.idAto;
    }

    @Generated
    public TipoAto getTipoAto() {
        return this.tipoAto;
    }

    @Generated
    public Long getNumeroAto() {
        return this.numeroAto;
    }

    @Generated
    public Long getAnoAto() {
        return this.anoAto;
    }

    @Generated
    public String getEsfera() {
        return this.esfera;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public LocalDate getDataAto() {
        return this.dataAto;
    }

    @Generated
    public LocalDate getDataInicioVigencia() {
        return this.dataInicioVigencia;
    }

    @Generated
    public LocalDate getDataFimVigencia() {
        return this.dataFimVigencia;
    }

    @Generated
    public String getModulo() {
        return this.modulo;
    }

    @Generated
    public Long getIdTce() {
        return this.idTce;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setIdAto(Long idAto) {
        this.idAto = idAto;
    }

    @Generated
    public void setTipoAto(TipoAto tipoAto) {
        this.tipoAto = tipoAto;
    }

    @Generated
    public void setNumeroAto(Long numeroAto) {
        this.numeroAto = numeroAto;
    }

    @Generated
    public void setAnoAto(Long anoAto) {
        this.anoAto = anoAto;
    }

    @Generated
    public void setEsfera(String esfera) {
        this.esfera = esfera;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setDataAto(LocalDate dataAto) {
        this.dataAto = dataAto;
    }

    @Generated
    public void setDataInicioVigencia(LocalDate dataInicioVigencia) {
        this.dataInicioVigencia = dataInicioVigencia;
    }

    @Generated
    public void setDataFimVigencia(LocalDate dataFimVigencia) {
        this.dataFimVigencia = dataFimVigencia;
    }

    @Generated
    public void setModulo(String modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setIdTce(Long idTce) {
        this.idTce = idTce;
    }

    @Generated
    public String toString() {
        return "Ato(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", idAto=" + this.getIdAto() + ", tipoAto=" + this.getTipoAto() + ", numeroAto=" + this.getNumeroAto() + ", anoAto=" + this.getAnoAto() + ", esfera=" + this.getEsfera() + ", descricao=" + this.getDescricao() + ", dataAto=" + this.getDataAto() + ", dataInicioVigencia=" + this.getDataInicioVigencia() + ", dataFimVigencia=" + this.getDataFimVigencia() + ", modulo=" + this.getModulo() + ", idTce=" + this.getIdTce() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ato)) {
            return false;
        }
        Ato other = (Ato)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Ato;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

